/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology.milstd2525.graphics.lines;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.Path;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.symbology.TacticalGraphicLabel;
import gov.nasa.worldwind.symbology.TacticalGraphicUtil;
import gov.nasa.worldwind.symbology.milstd2525.AbstractMilStd2525TacticalGraphic;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;

public class FireSupportLine
extends AbstractMilStd2525TacticalGraphic {
    protected static final int CFL_OUTLINE_STIPPLE_FACTOR = 12;
    protected static final Offset TOP_LABEL_OFFSET = Offset.fromFraction(0.0, 0.1);
    protected static final Offset BOTTOM_LABEL_OFFSET = Offset.fromFraction(0.0, -1.1);
    protected String additionalText;
    protected Path path = this.createPath();

    public static List<String> getSupportedGraphics() {
        return Arrays.asList("G-F-LCF--------", "G-F-LCC--------", "G-F-LCR--------");
    }

    public FireSupportLine(String string) {
        super(string);
    }

    public String getAdditionalText() {
        return this.additionalText;
    }

    public void setAdditionalText(String string) {
        this.additionalText = string;
        this.onModifierChanged();
    }

    @Override
    public Object getModifier(String string) {
        if ("T".equals(string) && this.additionalText != null) {
            return Arrays.asList(this.getText(), this.getAdditionalText());
        }
        return super.getModifier(string);
    }

    @Override
    public void setModifier(String string, Object object) {
        if ("T".equals(string) && object instanceof Iterable) {
            Iterator iterator = ((Iterable)object).iterator();
            if (iterator.hasNext()) {
                this.setText((String)iterator.next());
            }
            if (iterator.hasNext()) {
                this.setAdditionalText((String)iterator.next());
            }
        } else {
            super.setModifier(string, object);
        }
    }

    @Override
    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.path.setPositions(iterable);
    }

    @Override
    public Iterable<? extends Position> getPositions() {
        return this.path.getPositions();
    }

    @Override
    public Position getReferencePosition() {
        return this.path.getReferencePosition();
    }

    @Override
    protected void doRenderGraphic(DrawContext drawContext) {
        this.path.render(drawContext);
    }

    @Override
    protected void applyDelegateOwner(Object object) {
        this.path.setDelegateOwner(object);
    }

    @Override
    protected void createLabels() {
        String string = this.getEndOfLineText();
        this.addLabel(string).setTextAlign("gov.nasa.worldwind.avkey.Right");
        this.addLabel(string).setTextAlign("gov.nasa.worldwind.avkey.Left");
        String string2 = this.getTopLabelText();
        String string3 = this.getBottomLabelText();
        Offset offset = this.getTopLabelOffset();
        Offset offset2 = this.getBottomLabelOffset();
        TacticalGraphicLabel tacticalGraphicLabel = this.addLabel(string2);
        tacticalGraphicLabel.setOffset(offset);
        tacticalGraphicLabel = this.addLabel(string3);
        tacticalGraphicLabel.setOffset(offset2);
        if (this.isDrawDoubleLabel()) {
            tacticalGraphicLabel = this.addLabel(string2);
            tacticalGraphicLabel.setOffset(offset);
            tacticalGraphicLabel = this.addLabel(string3);
            tacticalGraphicLabel.setOffset(offset2);
        }
    }

    protected boolean isDrawDoubleLabel() {
        return !"G-F-LCC--------".equalsIgnoreCase(this.maskedSymbolCode);
    }

    protected String getEndOfLineText() {
        StringBuilder stringBuilder = new StringBuilder("PL");
        String string = this.getAdditionalText();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append(" ");
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    protected String getTopLabelText() {
        StringBuilder stringBuilder = new StringBuilder();
        String string = this.getText();
        if (!WWUtil.isEmpty(string)) {
            stringBuilder.append(string);
        }
        if ("G-F-LCF--------".equalsIgnoreCase(this.maskedSymbolCode)) {
            stringBuilder.append(" FSCL");
        } else if ("G-F-LCC--------".equalsIgnoreCase(this.maskedSymbolCode)) {
            stringBuilder.insert(0, "CFL ");
        } else if ("G-F-LCR--------".equalsIgnoreCase(this.maskedSymbolCode)) {
            stringBuilder.insert(0, "RFL ");
        }
        return stringBuilder.toString();
    }

    protected String getBottomLabelText() {
        StringBuilder stringBuilder = new StringBuilder();
        Object[] objectArray = TacticalGraphicUtil.getDateRange(this);
        if (objectArray[0] != null) {
            stringBuilder.append(objectArray[0]);
            stringBuilder.append("-\n");
        }
        if (objectArray[1] != null) {
            stringBuilder.append(objectArray[1]);
        }
        return stringBuilder.toString();
    }

    @Override
    protected void determineLabelPositions(DrawContext drawContext) {
        if (this.labels == null || this.labels.size() == 0) {
            return;
        }
        Object[] objectArray = this.computePathLength(drawContext);
        Position position = (Position)objectArray[0];
        Position position2 = (Position)objectArray[1];
        double d = (Double)objectArray[2];
        Iterator iterator = this.labels.iterator();
        TacticalGraphicLabel tacticalGraphicLabel = (TacticalGraphicLabel)iterator.next();
        tacticalGraphicLabel.setPosition(position);
        TacticalGraphicLabel tacticalGraphicLabel2 = (TacticalGraphicLabel)iterator.next();
        tacticalGraphicLabel2.setPosition(position2);
        if (position.longitude.degrees < position2.longitude.degrees) {
            tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Right");
            tacticalGraphicLabel2.setTextAlign("gov.nasa.worldwind.avkey.Left");
        } else {
            tacticalGraphicLabel.setTextAlign("gov.nasa.worldwind.avkey.Left");
            tacticalGraphicLabel2.setTextAlign("gov.nasa.worldwind.avkey.Right");
        }
        TacticalGraphicLabel tacticalGraphicLabel3 = (TacticalGraphicLabel)iterator.next();
        TacticalGraphicLabel tacticalGraphicLabel4 = (TacticalGraphicLabel)iterator.next();
        Iterable<? extends Position> iterable = this.getPositions();
        double d2 = iterator.hasNext() ? 0.25 : 0.5;
        double d3 = d * d2;
        TacticalGraphicUtil.placeLabelsOnPath(drawContext, iterable, tacticalGraphicLabel3, tacticalGraphicLabel4, d3);
        if (iterator.hasNext()) {
            tacticalGraphicLabel3 = (TacticalGraphicLabel)iterator.next();
            tacticalGraphicLabel4 = (TacticalGraphicLabel)iterator.next();
            d3 = d * 0.75;
            TacticalGraphicUtil.placeLabelsOnPath(drawContext, iterable, tacticalGraphicLabel3, tacticalGraphicLabel4, d3);
        }
    }

    protected Object[] computePathLength(DrawContext drawContext) {
        Position position;
        Iterator<? extends Position> iterator = this.path.getPositions().iterator();
        Globe globe = drawContext.getGlobe();
        Position position2 = position = iterator.next();
        double d = 0.0;
        Vec4 vec4 = globe.computePointFromLocation(position);
        while (iterator.hasNext()) {
            position2 = iterator.next();
            Vec4 vec42 = globe.computePointFromLocation(position2);
            d += vec42.distanceTo2(vec4);
            vec4 = vec42;
        }
        return new Object[]{position, position2, d};
    }

    @Override
    protected Offset getDefaultLabelOffset() {
        return TOP_LABEL_OFFSET;
    }

    protected Offset getTopLabelOffset() {
        return TOP_LABEL_OFFSET;
    }

    protected Offset getBottomLabelOffset() {
        return BOTTOM_LABEL_OFFSET;
    }

    @Override
    protected void applyDefaultAttributes(ShapeAttributes shapeAttributes) {
        super.applyDefaultAttributes(shapeAttributes);
        if ("G-F-LCC--------".equalsIgnoreCase(this.maskedSymbolCode)) {
            shapeAttributes.setOutlineStippleFactor(12);
            shapeAttributes.setOutlineStipplePattern(this.getOutlineStipplePattern());
        }
    }

    protected Path createPath() {
        Path path = new Path();
        path.setFollowTerrain(true);
        path.setPathType("gov.nasa.worldwind.avkey.GreatCircle");
        path.setAltitudeMode(1);
        path.setDelegateOwner(this.getActiveDelegateOwner());
        path.setAttributes(this.getActiveShapeAttributes());
        return path;
    }
}

