/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.symbology;

import com.sun.opengl.util.j2d.TextRenderer;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureData;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.View;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.LazilyLoadedTexture;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.Offset;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.render.Size;
import gov.nasa.worldwind.render.WWTexture;
import gov.nasa.worldwind.symbology.BasicTacticalSymbolAttributes;
import gov.nasa.worldwind.symbology.IconRetriever;
import gov.nasa.worldwind.symbology.TacticalSymbol;
import gov.nasa.worldwind.symbology.TacticalSymbolAttributes;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import gov.nasa.worldwind.util.OGLTextRenderer;
import gov.nasa.worldwind.util.OGLUtil;
import gov.nasa.worldwind.util.TextureAtlas;
import gov.nasa.worldwind.util.TextureAtlasElement;
import gov.nasa.worldwind.util.UnitsFormat;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import javax.media.opengl.GL;

public abstract class AbstractTacticalSymbol
extends WWObjectImpl
implements TacticalSymbol,
OrderedRenderable,
Movable {
    public static final UnitsFormat DEFAULT_UNITS_FORMAT = new UnitsFormat();
    public static final String LOADING_IMAGE_PATH = Configuration.getStringValue("gov.nasa.worldwind.avkey.MilStd2525LoadingIconPath", "images/doc-loading-128x128.png");
    protected static final String LAYOUT_ABSOLUTE = "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutAbsolute";
    protected static final String LAYOUT_RELATIVE = "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutRelative";
    protected static final String LAYOUT_NONE = "gov.nasa.worldwind.symbology.TacticalSymbol.LayoutNone";
    protected static final double DEFAULT_DEPTH_OFFSET = -8200.0;
    protected static final long DEFAULT_MAX_TIME_SINCE_LAST_USED = 10000L;
    protected static final TextureAtlas DEFAULT_GLYPH_ATLAS = new TextureAtlas(1024, 128, 2048, 2048);
    protected static final int MAX_SYMBOL_DIMENSION = 256;
    protected static final int DEFAULT_LABEL_LINES = 5;
    protected static TacticalSymbolAttributes defaultAttrs = new BasicTacticalSymbolAttributes();
    protected boolean visible = true;
    protected boolean highlighted;
    protected Position position;
    protected int altitudeMode = 0;
    protected boolean showGraphicModifiers = true;
    protected boolean showTextModifiers = true;
    protected Object delegateOwner;
    protected boolean enableBatchRendering = true;
    protected boolean enableBatchPicking = true;
    protected boolean showLocation = true;
    protected boolean showHostileIndicator;
    protected AVList modifiers = new AVListImpl();
    protected AVList activeModifiers = new AVListImpl();
    protected TacticalSymbolAttributes normalAttrs;
    protected TacticalSymbolAttributes highlightAttrs;
    protected TacticalSymbolAttributes activeAttrs = new BasicTacticalSymbolAttributes();
    protected Offset offset;
    protected Offset iconOffset;
    protected Size iconSize;
    protected Double depthOffset;
    protected IconRetriever iconRetriever;
    protected IconRetriever modifierRetriever;
    protected long frameNumber = -1L;
    protected Vec4 placePoint;
    protected Vec4 screenPoint;
    protected double eyeDistance;
    protected double sx;
    protected double sy;
    protected double dx;
    protected double dy;
    protected Rectangle iconRect;
    protected Rectangle layoutRect;
    protected Rectangle screenRect;
    protected Rectangle iconRectScaled;
    protected Rectangle layoutRectScaled;
    protected Rectangle staticScreenRect;
    protected Rectangle staticLayoutRect;
    protected boolean unresolvedGlyph;
    protected List<IconAtlasElement> currentGlyphs = new ArrayList<IconAtlasElement>();
    protected List<Label> currentLabels = new ArrayList<Label>();
    protected List<Line> currentLines = new ArrayList<Line>();
    protected WWTexture iconTexture;
    protected WWTexture activeIconTexture;
    protected TextureAtlas glyphAtlas;
    protected Map<String, IconAtlasElement> glyphMap = new HashMap<String, IconAtlasElement>();
    protected long maxTimeSinceLastUsed = 10000L;
    protected UnitsFormat unitsFormat = DEFAULT_UNITS_FORMAT;
    protected String formattedPosition;
    protected OGLStackHandler BEogsh = new OGLStackHandler();
    protected PickSupport pickSupport = new PickSupport();
    protected Layer pickLayer;

    protected AbstractTacticalSymbol() {
        this.setGlyphAtlas(DEFAULT_GLYPH_ATLAS);
    }

    protected AbstractTacticalSymbol(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.position = position;
        this.setGlyphAtlas(DEFAULT_GLYPH_ATLAS);
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.visible = bl;
    }

    @Override
    public boolean isHighlighted() {
        return this.highlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.highlighted = bl;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!position.equals(this.position)) {
            this.formattedPosition = null;
        }
        this.position = position;
    }

    @Override
    public int getAltitudeMode() {
        return this.altitudeMode;
    }

    @Override
    public void setAltitudeMode(int n) {
        this.altitudeMode = n;
    }

    @Override
    public boolean isShowGraphicModifiers() {
        return this.showGraphicModifiers;
    }

    @Override
    public void setShowGraphicModifiers(boolean bl) {
        if (this.showGraphicModifiers == bl) {
            return;
        }
        this.showGraphicModifiers = bl;
        this.reset();
    }

    @Override
    public boolean isShowTextModifiers() {
        return this.showTextModifiers;
    }

    @Override
    public void setShowTextModifiers(boolean bl) {
        if (this.showTextModifiers == bl) {
            return;
        }
        this.showTextModifiers = bl;
        this.reset();
    }

    @Override
    public boolean isShowLocation() {
        return this.showLocation;
    }

    @Override
    public void setShowLocation(boolean bl) {
        this.showLocation = bl;
    }

    @Override
    public boolean isShowHostileIndicator() {
        return this.showHostileIndicator;
    }

    @Override
    public void setShowHostileIndicator(boolean bl) {
        this.showHostileIndicator = bl;
    }

    public boolean isEnableBatchRendering() {
        return this.enableBatchRendering;
    }

    public void setEnableBatchRendering(boolean bl) {
        this.enableBatchRendering = bl;
    }

    public boolean isEnableBatchPicking() {
        return this.enableBatchPicking;
    }

    public void setEnableBatchPicking(boolean bl) {
        this.enableBatchPicking = bl;
    }

    @Override
    public Object getModifier(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ModifierIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return this.modifiers.getValue(string);
    }

    @Override
    public void setModifier(String string, Object object) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.ModifierIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.modifiers.setValue(string, object);
    }

    @Override
    public TacticalSymbolAttributes getAttributes() {
        return this.normalAttrs;
    }

    @Override
    public void setAttributes(TacticalSymbolAttributes tacticalSymbolAttributes) {
        this.normalAttrs = tacticalSymbolAttributes;
    }

    @Override
    public TacticalSymbolAttributes getHighlightAttributes() {
        return this.highlightAttrs;
    }

    @Override
    public void setHighlightAttributes(TacticalSymbolAttributes tacticalSymbolAttributes) {
        this.highlightAttrs = tacticalSymbolAttributes;
    }

    @Override
    public Object getDelegateOwner() {
        return this.delegateOwner;
    }

    @Override
    public void setDelegateOwner(Object object) {
        this.delegateOwner = object;
    }

    @Override
    public UnitsFormat getUnitsFormat() {
        return this.unitsFormat;
    }

    @Override
    public void setUnitsFormat(UnitsFormat unitsFormat) {
        if (unitsFormat == null) {
            String string = Logging.getMessage("nullValue.Format");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.unitsFormat != unitsFormat) {
            this.formattedPosition = null;
        }
        this.unitsFormat = unitsFormat;
    }

    @Override
    public Position getReferencePosition() {
        return this.getPosition();
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setPosition(position);
    }

    public Offset getOffset() {
        return this.offset;
    }

    public void setOffset(Offset offset) {
        this.offset = offset;
    }

    protected String getFormattedPosition() {
        Position position = this.getPosition();
        if (position == null) {
            return null;
        }
        if (this.formattedPosition == null) {
            this.formattedPosition = this.getUnitsFormat().latLon(position);
        }
        return this.formattedPosition;
    }

    protected Double getDepthOffset() {
        return this.depthOffset;
    }

    protected void setDepthOffset(Double d) {
        this.depthOffset = d;
    }

    protected IconRetriever getIconRetriever() {
        return this.iconRetriever;
    }

    protected void setIconRetriever(IconRetriever iconRetriever) {
        this.iconRetriever = iconRetriever;
    }

    protected IconRetriever getModifierRetriever() {
        return this.modifierRetriever;
    }

    protected void setModifierRetriever(IconRetriever iconRetriever) {
        this.modifierRetriever = iconRetriever;
        this.reset();
    }

    protected TextureAtlas getGlyphAtlas() {
        return this.glyphAtlas;
    }

    protected void setGlyphAtlas(TextureAtlas textureAtlas) {
        this.glyphAtlas = textureAtlas;
    }

    @Override
    public double getDistanceFromEye() {
        return this.eyeDistance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void pick(DrawContext drawContext, Point point) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.pickSupport.clearPickList();
        try {
            this.pickSupport.beginPicking(drawContext);
            this.render(drawContext);
        }
        finally {
            this.pickSupport.endPicking(drawContext);
            this.pickSupport.resolvePick(drawContext, point, this.pickLayer);
        }
    }

    @Override
    public void render(DrawContext drawContext) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (!this.isVisible()) {
            return;
        }
        if (drawContext.isOrderedRenderingMode()) {
            this.drawOrderedRenderable(drawContext);
        } else {
            this.makeOrderedRenderable(drawContext);
        }
    }

    protected void makeOrderedRenderable(DrawContext drawContext) {
        if (drawContext.getFrameTimeStamp() != this.frameNumber) {
            this.computeSymbolPoints(drawContext);
            if (this.placePoint == null || this.screenPoint == null) {
                return;
            }
            double d = drawContext.getView().getHorizonDistance();
            if (this.eyeDistance > d) {
                return;
            }
            if (this.screenRect == null && !this.intersectsFrustum(drawContext)) {
                return;
            }
            this.determineActiveAttributes();
            if (this.getActiveAttributes() == null) {
                return;
            }
            this.computeScale();
            this.layout(drawContext);
            this.computeTransform(drawContext);
            this.frameNumber = drawContext.getFrameTimeStamp();
        }
        if (this.intersectsFrustum(drawContext)) {
            drawContext.addOrderedRenderable(this);
        }
        if (drawContext.isPickingMode()) {
            this.pickLayer = drawContext.getCurrentLayer();
        }
    }

    protected void computeSymbolPoints(DrawContext drawContext) {
        this.placePoint = null;
        this.screenPoint = null;
        this.eyeDistance = 0.0;
        Position position = this.getPosition();
        if (position == null) {
            return;
        }
        if (this.altitudeMode == 1) {
            this.placePoint = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        } else if (this.altitudeMode == 2) {
            this.placePoint = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), position.getAltitude());
        } else {
            double d = position.getElevation() * drawContext.getVerticalExaggeration();
            this.placePoint = drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), d);
        }
        if (this.placePoint == null) {
            return;
        }
        this.screenPoint = drawContext.getView().project(this.placePoint);
        this.eyeDistance = this.placePoint.distanceTo3(drawContext.getView().getEyePoint());
    }

    protected void determineActiveAttributes() {
        Double d;
        Double d2;
        Font font = this.activeAttrs.getTextModifierFont();
        Double d3 = this.activeAttrs.getScale();
        Double d4 = this.activeAttrs.getOpacity();
        if (this.isHighlighted()) {
            if (this.getHighlightAttributes() != null) {
                this.activeAttrs.copy(this.getHighlightAttributes());
            } else if (this.getAttributes() != null) {
                this.activeAttrs.copy(this.getAttributes());
            } else {
                this.activeAttrs.copy(defaultAttrs);
            }
        } else if (this.getAttributes() != null) {
            this.activeAttrs.copy(this.getAttributes());
        } else {
            this.activeAttrs.copy(defaultAttrs);
        }
        Font font2 = this.activeAttrs.getTextModifierFont();
        if (font2 != null && !font2.equals(font) || font2 == null && font != null) {
            this.reset();
        }
        if ((d2 = this.activeAttrs.getOpacity()) != null && !d2.equals(d4) || d2 == null && d4 != null) {
            this.reset();
        }
        if ((d = this.activeAttrs.getScale()) != null && !d.equals(d3) || d == null && d3 != null) {
            this.reset();
        }
    }

    protected TacticalSymbolAttributes getActiveAttributes() {
        return this.activeAttrs;
    }

    protected void reset() {
        this.staticScreenRect = null;
        this.staticLayoutRect = null;
    }

    protected void layout(DrawContext drawContext) {
        AVListImpl aVListImpl = new AVListImpl();
        aVListImpl.setValues(this.modifiers);
        this.applyImplicitModifiers(aVListImpl);
        boolean bl = this.mustDrawGraphicModifiers(drawContext) || this.mustDrawTextModifiers(drawContext);
        AVList aVList = this.assembleIconRetrieverParameters(null);
        IconSource iconSource = new IconSource(this.getIconRetriever(), this.getIdentifier(), aVList);
        if (this.mustLayout(iconSource, aVListImpl)) {
            this.screenRect = null;
            this.layoutRect = null;
            this.unresolvedGlyph = false;
            if (this.mustDrawIcon(drawContext)) {
                this.layoutIcon(drawContext, iconSource);
            }
            if (bl) {
                this.layoutStaticModifiers(drawContext, aVListImpl);
            }
            this.staticScreenRect = new Rectangle(this.screenRect);
            this.staticLayoutRect = new Rectangle(this.layoutRect);
            this.activeModifiers.setValues(aVListImpl);
            this.removeDeadModifiers(System.currentTimeMillis());
        } else {
            this.layoutRect = new Rectangle(this.staticLayoutRect);
            this.screenRect = new Rectangle(this.staticScreenRect);
        }
        if (bl) {
            this.layoutDynamicModifiers(drawContext, aVListImpl);
        }
    }

    protected boolean mustLayout(IconSource iconSource, AVList aVList) {
        if (this.unresolvedGlyph) {
            return true;
        }
        if (this.staticScreenRect == null || this.staticLayoutRect == null) {
            return true;
        }
        if (!((Object)this.activeModifiers.getEntries()).equals(aVList.getEntries())) {
            return true;
        }
        if (this.iconTexture == null || this.iconTexture != this.activeIconTexture) {
            return true;
        }
        return !this.iconTexture.getImageSource().equals(iconSource);
    }

    protected void layoutIcon(DrawContext drawContext, IconSource iconSource) {
        boolean bl;
        if (this.getIconRetriever() == null) {
            return;
        }
        if (this.iconTexture == null || !this.iconTexture.getImageSource().equals(iconSource)) {
            this.iconTexture = new IconTexture(iconSource);
        }
        if (this.activeIconTexture != this.iconTexture && this.iconTexture != null && this.iconTexture.bind(drawContext)) {
            this.activeIconTexture = this.iconTexture;
            this.iconRect = null;
        }
        boolean bl2 = bl = this.activeIconTexture != null;
        if (!bl) {
            this.activeIconTexture = new BasicWWTexture(LOADING_IMAGE_PATH);
            bl = this.activeIconTexture.bind(drawContext);
        }
        if (this.iconRect == null && bl) {
            int n = this.activeIconTexture.getWidth(drawContext);
            int n2 = this.activeIconTexture.getHeight(drawContext);
            Point point = this.iconOffset != null ? this.iconOffset.computeOffset(n, n2, null, null) : new Point(0, 0);
            Dimension dimension = this.iconSize != null ? this.iconSize.compute(n, n2, n, n2) : new Dimension(n, n2);
            this.iconRect = new Rectangle((int)((Point2D)point).getX(), (int)((Point2D)point).getY(), dimension.width, dimension.height);
        }
        if (this.iconRect != null) {
            if (this.screenRect != null) {
                this.screenRect.add(this.iconRect);
            } else {
                this.screenRect = new Rectangle(this.iconRect);
            }
            if (this.layoutRect != null) {
                this.layoutRect.add(this.iconRect);
            } else {
                this.layoutRect = new Rectangle(this.iconRect);
            }
        }
    }

    protected AVList assembleIconRetrieverParameters(AVList aVList) {
        Material material;
        if (aVList == null) {
            aVList = new AVListImpl();
        }
        if ((material = this.getActiveAttributes().getInteriorMaterial()) != null) {
            aVList.setValue("gov.nasa.worldwind.avkey.Color", material.getDiffuse());
        }
        return aVList;
    }

    protected void layoutStaticModifiers(DrawContext drawContext, AVList aVList) {
        if (this.iconRect == null) {
            return;
        }
        if (this.mustDrawGraphicModifiers(drawContext)) {
            this.layoutGraphicModifiers(drawContext, aVList);
        }
        this.computeScaledBounds(drawContext, aVList);
        if (this.mustDrawTextModifiers(drawContext)) {
            this.layoutTextModifiers(drawContext, aVList);
        }
    }

    protected void layoutGraphicModifiers(DrawContext drawContext, AVList aVList) {
    }

    protected void layoutTextModifiers(DrawContext drawContext, AVList aVList) {
    }

    protected void layoutDynamicModifiers(DrawContext drawContext, AVList aVList) {
    }

    protected void applyImplicitModifiers(AVList aVList) {
    }

    protected Rectangle layoutRect(Offset offset, Offset offset2, Dimension dimension, Object object) {
        Cloneable cloneable;
        int n = 0;
        int n2 = 0;
        if (offset != null) {
            cloneable = LAYOUT_ABSOLUTE.equals(object) ? this.iconRect : (LAYOUT_RELATIVE.equals(object) ? this.layoutRect : this.iconRect);
            Point2D.Double double_ = offset.computeOffset(((Rectangle)cloneable).getWidth(), ((Rectangle)cloneable).getHeight(), null, null);
            n = (int)((double)n + (((Rectangle)cloneable).getX() + ((Point2D)double_).getX()));
            n2 = (int)((double)n2 + (((Rectangle)cloneable).getY() + ((Point2D)double_).getY()));
        }
        if (offset2 != null) {
            cloneable = offset2.computeOffset(dimension.getWidth(), dimension.getHeight(), null, null);
            n = (int)((double)n - ((Point2D)cloneable).getX());
            n2 = (int)((double)n2 - ((Point2D)cloneable).getY());
        }
        cloneable = new Rectangle(n, n2, dimension.width, dimension.height);
        if (this.screenRect != null) {
            this.screenRect.add((Rectangle)cloneable);
        } else {
            this.screenRect = new Rectangle((Rectangle)cloneable);
        }
        if (LAYOUT_ABSOLUTE.equals(object) || LAYOUT_RELATIVE.equals(object)) {
            if (this.layoutRect != null) {
                this.layoutRect.add((Rectangle)cloneable);
            } else {
                this.layoutRect = new Rectangle((Rectangle)cloneable);
            }
        }
        return cloneable;
    }

    protected Rectangle layoutLabelRect(Offset offset, Offset offset2, Dimension dimension, Object object) {
        Cloneable cloneable;
        Cloneable cloneable2;
        int n = 0;
        int n2 = 0;
        if (offset != null) {
            cloneable2 = LAYOUT_ABSOLUTE.equals(object) ? this.iconRectScaled : (LAYOUT_RELATIVE.equals(object) ? this.layoutRectScaled : this.iconRectScaled);
            cloneable = offset.computeOffset(((Rectangle)cloneable2).getWidth(), ((Rectangle)cloneable2).getHeight(), null, null);
            n = (int)((double)n + (((Rectangle)cloneable2).getX() + ((Point2D)cloneable).getX()));
            n2 = (int)((double)n2 + (((Rectangle)cloneable2).getY() + ((Point2D)cloneable).getY()));
        }
        if (offset2 != null) {
            cloneable2 = offset2.computeOffset(dimension.getWidth(), dimension.getHeight(), null, null);
            n = (int)((double)n - ((Point2D)cloneable2).getX());
            n2 = (int)((double)n2 - ((Point2D)cloneable2).getY());
        }
        cloneable2 = new Rectangle(n, n2, dimension.width, dimension.height);
        if (LAYOUT_ABSOLUTE.equals(object) || LAYOUT_RELATIVE.equals(object)) {
            if (this.layoutRectScaled != null) {
                this.layoutRectScaled.add((Rectangle)cloneable2);
            } else {
                this.layoutRectScaled = new Rectangle((Rectangle)cloneable2);
            }
            cloneable = this.computeScaledRect((Rectangle)cloneable2, ((Rectangle)cloneable2).getSize(), 1.0 / this.sx, 1.0 / this.sy);
            if (this.layoutRect != null) {
                this.layoutRect.add((Rectangle)cloneable);
            } else {
                this.layoutRect = new Rectangle((Rectangle)cloneable);
            }
        }
        return cloneable2;
    }

    protected List<? extends Point2D> layoutPoints(Offset offset, List<? extends Point2D> list, Object object, int n) {
        Point2D point2D;
        int n2 = 0;
        int n3 = 0;
        if (offset != null) {
            Rectangle rectangle = LAYOUT_ABSOLUTE.equals(object) ? this.iconRect : (LAYOUT_RELATIVE.equals(object) ? this.layoutRect : this.iconRect);
            point2D = offset.computeOffset(rectangle.getWidth(), rectangle.getHeight(), null, null);
            n2 = (int)((double)n2 + (rectangle.getX() + point2D.getX()));
            n3 = (int)((double)n3 + (rectangle.getY() + point2D.getY()));
        }
        for (int i = 0; i < list.size(); ++i) {
            point2D = list.get(i);
            point2D.setLocation((double)n2 + point2D.getX(), (double)n3 + point2D.getY());
            if (this.screenRect != null) {
                this.screenRect.add(point2D);
            } else {
                this.screenRect = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 0, 0);
            }
            if (i >= n || !LAYOUT_ABSOLUTE.equals(object) && !LAYOUT_RELATIVE.equals(object)) continue;
            if (this.layoutRect != null) {
                this.layoutRect.add(point2D);
                continue;
            }
            this.layoutRect = new Rectangle((int)point2D.getX(), (int)point2D.getY(), 0, 0);
        }
        return list;
    }

    protected void addGlyph(DrawContext drawContext, Offset offset, Offset offset2, String string) {
        this.addGlyph(drawContext, offset, offset2, string, null, null);
    }

    protected void addGlyph(DrawContext drawContext, Offset offset, Offset offset2, String string, AVList aVList, Object object) {
        IconAtlasElement iconAtlasElement = this.getGlyph(string, aVList);
        if (iconAtlasElement.load(drawContext)) {
            Rectangle rectangle = this.layoutRect(offset, offset2, iconAtlasElement.getSize(), object);
            iconAtlasElement.setPoint(rectangle.getLocation());
            this.currentGlyphs.add(iconAtlasElement);
        } else {
            this.unresolvedGlyph = true;
        }
    }

    protected void addLabel(DrawContext drawContext, Offset offset, Offset offset2, String string) {
        this.addLabel(drawContext, offset, offset2, string, null, null, null);
    }

    protected void addLabel(DrawContext drawContext, Offset offset, Offset offset2, String string, Font font, Color color, Object object) {
        Serializable serializable;
        Serializable serializable2;
        Object object2;
        if (font == null && (font = this.getActiveAttributes().getTextModifierFont()) == null) {
            font = BasicTacticalSymbolAttributes.DEFAULT_TEXT_MODIFIER_FONT;
        }
        if (color == null) {
            object2 = this.getActiveAttributes().getTextModifierMaterial();
            if (object2 == null) {
                object2 = BasicTacticalSymbolAttributes.DEFAULT_TEXT_MODIFIER_MATERIAL;
            }
            if ((serializable2 = this.getActiveAttributes().getOpacity()) == null) {
                serializable2 = Double.valueOf(1.0);
            }
            int n = (int)(255.0 * (Double)serializable2 + 0.5);
            serializable = ((Material)object2).getDiffuse();
            color = new Color(serializable.getRed(), serializable.getGreen(), serializable.getBlue(), n);
        }
        object2 = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
        serializable2 = ((TextRenderer)object2).getBounds(string).getBounds();
        Rectangle rectangle = this.layoutLabelRect(offset, offset2, ((Rectangle)serializable2).getSize(), object);
        serializable = new Point(rectangle.getLocation().x, rectangle.getLocation().y + ((Rectangle)serializable2).y + ((Rectangle)serializable2).height);
        this.currentLabels.add(new Label((TextRenderer)object2, string, (Point)serializable, color));
    }

    protected void addLine(DrawContext drawContext, Offset offset, List<? extends Point2D> list) {
        this.addLine(drawContext, offset, list, null, 0);
    }

    protected void addLine(DrawContext drawContext, Offset offset, List<? extends Point2D> list, Object object, int n) {
        list = this.layoutPoints(offset, list, object, n);
        this.currentLines.add(new Line(list));
    }

    protected IconAtlasElement getGlyph(String string, AVList aVList) {
        if (this.getGlyphAtlas() == null || this.getModifierRetriever() == null) {
            return null;
        }
        IconAtlasElement iconAtlasElement = this.glyphMap.get(string);
        if (iconAtlasElement == null) {
            IconSource iconSource = new IconSource(this.getModifierRetriever(), string, aVList);
            iconAtlasElement = new IconAtlasElement(this.getGlyphAtlas(), iconSource);
            this.glyphMap.put(string, iconAtlasElement);
        }
        iconAtlasElement.lastUsed = System.currentTimeMillis();
        return iconAtlasElement;
    }

    protected void removeDeadModifiers(long l) {
        if (this.glyphMap.isEmpty()) {
            return;
        }
        ArrayList<String> arrayList = null;
        for (Map.Entry<String, IconAtlasElement> object : this.glyphMap.entrySet()) {
            if (object.getValue().lastUsed + this.maxTimeSinceLastUsed >= l) continue;
            if (arrayList == null) {
                arrayList = new ArrayList<String>();
            }
            arrayList.add(object.getKey());
        }
        if (arrayList == null) {
            return;
        }
        for (String string : arrayList) {
            this.glyphMap.remove(string);
        }
    }

    protected void computeScale() {
        if (this.getActiveAttributes().getScale() != null) {
            this.sx = this.getActiveAttributes().getScale();
            this.sy = this.getActiveAttributes().getScale();
        } else {
            this.sx = 1.0;
            this.sy = 1.0;
        }
    }

    protected void computeTransform(DrawContext drawContext) {
        if (this.getOffset() != null && this.iconRect != null) {
            Point2D.Double double_ = this.getOffset().computeOffset(this.iconRect.getWidth(), this.iconRect.getHeight(), null, null);
            this.dx = -this.iconRect.getX() - ((Point2D)double_).getX();
            this.dy = -this.iconRect.getY() - ((Point2D)double_).getY();
        } else {
            this.dx = 0.0;
            this.dy = 0.0;
        }
    }

    protected void computeScaledBounds(DrawContext drawContext, AVList aVList) {
        Dimension dimension = this.computeMinTextLayout(drawContext, aVList);
        this.iconRectScaled = this.computeScaledRect(this.iconRect, dimension, this.sx, this.sy);
        this.layoutRectScaled = this.computeScaledRect(this.layoutRect, dimension, this.sx, this.sy);
    }

    protected Dimension computeMinTextLayout(DrawContext drawContext, AVList aVList) {
        Font font = this.getActiveAttributes().getTextModifierFont();
        if (font == null) {
            font = BasicTacticalSymbolAttributes.DEFAULT_TEXT_MODIFIER_FONT;
        }
        TextRenderer textRenderer = OGLTextRenderer.getOrCreateTextRenderer(drawContext.getTextRendererCache(), font);
        Rectangle2D rectangle2D = textRenderer.getBounds("E");
        int n = this.getMaxLabelLines(aVList);
        int n2 = (int)(rectangle2D.getHeight() * (double)n * 1.5);
        return new Dimension(n2, n2);
    }

    protected int getMaxLabelLines(AVList aVList) {
        return 5;
    }

    protected Rectangle computeScaledRect(Rectangle rectangle, Dimension dimension, double d, double d2) {
        double d3 = rectangle.getX() * d;
        double d4 = rectangle.getY() * d2;
        double d5 = rectangle.getWidth() * d;
        double d6 = rectangle.getHeight() * d2;
        double d7 = dimension.getWidth();
        double d8 = dimension.getHeight();
        if (d5 < d7) {
            d3 += (d5 - d7) / 2.0;
            d5 = d7;
        }
        if (d6 < d8) {
            d4 += (d6 - d8) / 2.0;
            d6 = d8;
        }
        return new Rectangle((int)d3, (int)d4, (int)Math.ceil(d5), (int)Math.ceil(d6));
    }

    protected Rectangle computeScreenExtent() {
        double d;
        double d2;
        double d3;
        double d4;
        if (this.screenRect != null) {
            d4 = this.screenPoint.x + this.sx * (this.dx + this.screenRect.getX());
            d3 = this.screenPoint.y + this.sy * (this.dy + this.screenRect.getY());
            d2 = this.sx * this.screenRect.getWidth();
            d = this.sy * this.screenRect.getHeight();
        } else {
            d2 = 256.0;
            d = 256.0;
            d4 = this.screenPoint.x - d2 / 2.0;
            d3 = this.screenPoint.y - d / 2.0;
        }
        return new Rectangle((int)d4, (int)d3, (int)Math.ceil(d2), (int)Math.ceil(d));
    }

    protected int getMaxSymbolDimension() {
        return 256;
    }

    protected boolean intersectsFrustum(DrawContext drawContext) {
        View view = drawContext.getView();
        if (this.placePoint != null && (view.getFrustumInModelCoordinates().getNear().distanceTo(this.placePoint) < 0.0 || view.getFrustumInModelCoordinates().getFar().distanceTo(this.placePoint) < 0.0)) {
            return false;
        }
        Rectangle rectangle = this.computeScreenExtent();
        if (rectangle != null) {
            if (drawContext.isPickingMode()) {
                return drawContext.getPickFrustums().intersectsAny(rectangle);
            }
            return view.getViewport().intersects(rectangle);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawOrderedRenderable(DrawContext drawContext) {
        this.beginDrawing(drawContext, 0);
        try {
            this.doDrawOrderedRenderable(drawContext, this.pickSupport);
            if (this.isEnableBatchRendering()) {
                this.drawBatched(drawContext);
            }
        }
        finally {
            this.endDrawing(drawContext);
        }
    }

    protected void drawBatched(DrawContext drawContext) {
        block3: {
            AbstractTacticalSymbol abstractTacticalSymbol;
            OrderedRenderable orderedRenderable;
            block2: {
                AbstractTacticalSymbol abstractTacticalSymbol2;
                orderedRenderable = drawContext.peekOrderedRenderables();
                if (drawContext.isPickingMode()) break block2;
                while (orderedRenderable != null && orderedRenderable instanceof AbstractTacticalSymbol && (abstractTacticalSymbol2 = (AbstractTacticalSymbol)orderedRenderable).isEnableBatchRendering()) {
                    drawContext.pollOrderedRenderables();
                    abstractTacticalSymbol2.doDrawOrderedRenderable(drawContext, this.pickSupport);
                    orderedRenderable = drawContext.peekOrderedRenderables();
                }
                break block3;
            }
            if (!this.isEnableBatchPicking()) break block3;
            while (orderedRenderable != null && orderedRenderable instanceof AbstractTacticalSymbol && (abstractTacticalSymbol = (AbstractTacticalSymbol)orderedRenderable).isEnableBatchRendering() && abstractTacticalSymbol.isEnableBatchPicking() && abstractTacticalSymbol.pickLayer == this.pickLayer) {
                drawContext.pollOrderedRenderables();
                abstractTacticalSymbol.doDrawOrderedRenderable(drawContext, this.pickSupport);
                orderedRenderable = drawContext.peekOrderedRenderables();
            }
        }
    }

    protected void beginDrawing(DrawContext drawContext, int n) {
        GL gL = drawContext.getGL();
        Rectangle rectangle = drawContext.getView().getViewport();
        this.BEogsh.clear();
        this.BEogsh.pushAttrib(gL, n |= 0x4105);
        this.BEogsh.pushProjectionIdentity(gL);
        gL.glOrtho(0.0, rectangle.getWidth(), 0.0, rectangle.getHeight(), 0.0, -1.0);
        this.BEogsh.pushModelviewIdentity(gL);
        gL.glEnableClientState(32884);
        gL.glEnableClientState(32888);
        gL.glEnable(3008);
        gL.glAlphaFunc(516, 0.0f);
        if (!drawContext.isDeepPickingEnabled()) {
            gL.glEnable(2929);
        }
        gL.glDepthFunc(513);
        gL.glDepthMask(false);
        gL.glEnable(32823);
        gL.glPolygonOffset(0.0f, -8200.0f);
        gL.glEnable(3553);
        if (drawContext.isPickingMode()) {
            gL.glTexEnvi(8960, 8704, 34160);
            gL.glTexEnvi(8960, 34176, 34168);
            gL.glTexEnvi(8960, 34161, 7681);
            gL.glLineWidth(9.0f);
        } else {
            gL.glEnable(3042);
            OGLUtil.applyBlending(gL, true);
            gL.glEnable(2848);
            gL.glLineWidth(3.0f);
        }
    }

    protected void endDrawing(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glDisableClientState(32884);
        gL.glDisableClientState(32888);
        gL.glDisable(32823);
        gL.glPolygonOffset(0.0f, 0.0f);
        gL.glDisable(3553);
        gL.glBindTexture(3553, 0);
        if (drawContext.isPickingMode()) {
            gL.glTexEnvi(8960, 8704, 8448);
            gL.glTexEnvi(8960, 34176, 5890);
            gL.glTexEnvi(8960, 34161, 8448);
        }
        this.BEogsh.pop(gL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        Serializable serializable;
        GL gL = drawContext.getGL();
        if (drawContext.isPickingMode()) {
            serializable = drawContext.getUniquePickColor();
            pickSupport.addPickableObject(this.createPickedObject(((Color)serializable).getRGB()));
            gL.glColor3ub((byte)((Color)serializable).getRed(), (byte)((Color)serializable).getGreen(), (byte)((Color)serializable).getBlue());
        } else {
            float f = this.getActiveAttributes().getOpacity() != null ? this.getActiveAttributes().getOpacity().floatValue() : 1.0f;
            gL.glColor4f(f, f, f, f);
        }
        serializable = this.getDepthOffset();
        try {
            if (serializable != null) {
                gL.glPolygonOffset(0.0f, ((Double)serializable).floatValue());
            }
            this.prepareToDraw(drawContext);
            this.draw(drawContext);
        }
        finally {
            if (serializable != null) {
                gL.glPolygonOffset(0.0f, -8200.0f);
            }
        }
    }

    protected void prepareToDraw(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glLoadIdentity();
        gL.glTranslated(this.screenPoint.x, this.screenPoint.y, this.screenPoint.z);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        try {
            gL.glPushMatrix();
            gL.glScaled(this.sx, this.sy, 1.0);
            gL.glTranslated(this.dx, this.dy, 0.0);
            if (this.mustDrawIcon(drawContext)) {
                this.drawIcon(drawContext);
            }
            if (this.mustDrawGraphicModifiers(drawContext)) {
                this.drawGraphicModifiers(drawContext);
            }
        }
        finally {
            gL.glPopMatrix();
        }
        if (this.mustDrawTextModifiers(drawContext) && !drawContext.isPickingMode()) {
            try {
                gL.glPushMatrix();
                gL.glTranslated(this.dx * this.sx, this.dy * this.sy, 0.0);
                this.drawTextModifiers(drawContext);
            }
            finally {
                gL.glPopMatrix();
            }
        }
    }

    protected boolean mustDrawIcon(DrawContext drawContext) {
        return true;
    }

    protected boolean mustDrawGraphicModifiers(DrawContext drawContext) {
        return this.isShowGraphicModifiers();
    }

    protected boolean mustDrawTextModifiers(DrawContext drawContext) {
        return this.isShowTextModifiers();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawIcon(DrawContext drawContext) {
        if (this.activeIconTexture == null || this.iconRect == null) {
            return;
        }
        if (!this.activeIconTexture.bind(drawContext)) {
            return;
        }
        GL gL = drawContext.getGL();
        try {
            gL.glPushMatrix();
            gL.glScaled(this.activeIconTexture.getWidth(drawContext), this.activeIconTexture.getHeight(drawContext), 1.0);
            drawContext.drawUnitQuad(this.activeIconTexture.getTexCoords());
        }
        finally {
            gL.glPopMatrix();
        }
    }

    protected void drawGraphicModifiers(DrawContext drawContext) {
        this.drawGlyphs(drawContext);
        this.drawLines(drawContext);
    }

    protected void drawTextModifiers(DrawContext drawContext) {
        this.drawLabels(drawContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawGlyphs(DrawContext drawContext) {
        if (this.glyphAtlas == null || this.currentGlyphs.isEmpty()) {
            return;
        }
        if (!this.glyphAtlas.bind(drawContext)) {
            return;
        }
        GL gL = drawContext.getGL();
        for (IconAtlasElement iconAtlasElement : this.currentGlyphs) {
            Point point = iconAtlasElement.getPoint();
            Dimension dimension = iconAtlasElement.getSize();
            TextureCoords textureCoords = iconAtlasElement.getTexCoords();
            if (point == null || dimension == null || textureCoords == null) continue;
            try {
                gL.glPushMatrix();
                gL.glTranslated(point.getX(), point.getY(), 0.0);
                gL.glScaled(dimension.getWidth(), dimension.getHeight(), 1.0);
                drawContext.drawUnitQuad(textureCoords);
            }
            finally {
                gL.glPopMatrix();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLabels(DrawContext drawContext) {
        if (this.currentLabels.isEmpty()) {
            return;
        }
        GL gL = drawContext.getGL();
        TextRenderer textRenderer = null;
        try {
            gL.glDisable(2929);
            for (Label label : this.currentLabels) {
                if (textRenderer == null || textRenderer != label.getTextRenderer()) {
                    if (textRenderer != null) {
                        textRenderer.end3DRendering();
                    }
                    textRenderer = label.getTextRenderer();
                    textRenderer.begin3DRendering();
                }
                Point point = label.getPoint();
                textRenderer.setColor(label.getColor());
                textRenderer.draw(label.getText(), point.x, point.y);
            }
        }
        finally {
            if (textRenderer != null) {
                textRenderer.end3DRendering();
            }
            gL.glEnable(2929);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void drawLines(DrawContext drawContext) {
        Double d = this.getActiveAttributes().getOpacity() != null ? this.getActiveAttributes().getOpacity() : 1.0;
        GL gL = drawContext.getGL();
        try {
            gL.glDisable(3553);
            double d2 = this.screenPoint.z - 0.00391006472;
            d2 = d2 < 0.0 ? 0.0 : (d2 > 1.0 ? 1.0 : d2);
            gL.glDepthRange(d2, d2);
            if (!drawContext.isPickingMode()) {
                gL.glColor4f(0.0f, 0.0f, 0.0f, d.floatValue());
            }
            for (Line line : this.currentLines) {
                try {
                    gL.glBegin(3);
                    for (Point2D point2D : line.getPoints()) {
                        gL.glVertex2d(point2D.getX(), point2D.getY());
                    }
                }
                finally {
                    gL.glEnd();
                }
            }
        }
        finally {
            gL.glEnable(3553);
            gL.glDepthRange(0.0, 1.0);
            if (!drawContext.isPickingMode()) {
                gL.glColor4f(d.floatValue(), d.floatValue(), d.floatValue(), d.floatValue());
            }
        }
    }

    protected PickedObject createPickedObject(int n) {
        Object object = this.getDelegateOwner();
        return new PickedObject(n, object != null ? object : this);
    }

    static {
        defaultAttrs.setOpacity(1.0);
        defaultAttrs.setScale(1.0);
        defaultAttrs.setTextModifierMaterial(BasicTacticalSymbolAttributes.DEFAULT_TEXT_MODIFIER_MATERIAL);
        DEFAULT_GLYPH_ATLAS.setEvictOldElements(true);
    }

    protected static class Line {
        protected Iterable<? extends Point2D> points;

        public Line() {
        }

        public Line(Iterable<? extends Point2D> iterable) {
            if (iterable == null) {
                String string = Logging.getMessage("nullValue.IterableIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.points = iterable;
        }

        public Iterable<? extends Point2D> getPoints() {
            return this.points;
        }

        public void setPoints(Iterable<? extends Point2D> iterable) {
            this.points = iterable;
        }
    }

    protected static class Label {
        protected TextRenderer renderer;
        protected String text;
        protected Point point;
        protected Color color;

        public Label(TextRenderer textRenderer, String string, Point point, Color color) {
            if (textRenderer == null) {
                String string2 = Logging.getMessage("nullValue.RendererIsNull");
                Logging.logger().severe(string2);
                throw new IllegalArgumentException(string2);
            }
            if (string == null) {
                String string3 = Logging.getMessage("nullValue.StringIsNull");
                Logging.logger().severe(string3);
                throw new IllegalArgumentException(string3);
            }
            if (point == null) {
                String string4 = Logging.getMessage("nullValue.PointIsNull");
                Logging.logger().severe(string4);
                throw new IllegalArgumentException(string4);
            }
            if (color == null) {
                String string5 = Logging.getMessage("nullValue.ColorIsNull");
                Logging.logger().severe(string5);
                throw new IllegalArgumentException(string5);
            }
            this.renderer = textRenderer;
            this.text = string;
            this.point = point;
            this.color = color;
        }

        public TextRenderer getTextRenderer() {
            return this.renderer;
        }

        public String getText() {
            return this.text;
        }

        public Point getPoint() {
            return this.point;
        }

        public Color getColor() {
            return this.color;
        }
    }

    protected static class IconAtlasElement
    extends TextureAtlasElement {
        protected Point point;
        protected long lastUsed = System.currentTimeMillis();

        public IconAtlasElement(TextureAtlas textureAtlas, IconSource iconSource) {
            super(textureAtlas, iconSource);
        }

        public Point getPoint() {
            return this.point;
        }

        public void setPoint(Point point) {
            this.point = point;
        }

        @Override
        protected boolean loadImage() {
            BufferedImage bufferedImage = this.createModifierImage();
            if (bufferedImage != null) {
                this.setImage(bufferedImage);
            }
            return bufferedImage != null;
        }

        protected BufferedImage createModifierImage() {
            try {
                IconSource iconSource = (IconSource)this.getImageSource();
                BufferedImage bufferedImage = iconSource.getRetriever().createIcon(iconSource.getSymbolId(), iconSource.getRetrieverParams());
                if (bufferedImage == null) {
                    this.imageInitializationFailed = true;
                    return null;
                }
                return bufferedImage;
            }
            catch (Exception exception) {
                String string = Logging.getMessage("Symbology.ExceptionRetrievingGraphicModifier", this.getImageSource());
                Logging.logger().log(Level.SEVERE, string, exception);
                this.imageInitializationFailed = true;
                return null;
            }
        }
    }

    protected static class IconTexture
    extends LazilyLoadedTexture {
        public IconTexture(IconSource iconSource) {
            super(iconSource);
        }

        public IconTexture(IconSource iconSource, boolean bl) {
            super(iconSource, bl);
        }

        protected boolean loadTextureData() {
            TextureData textureData = this.createIconTextureData();
            if (textureData != null) {
                this.setTextureData(textureData);
            }
            return textureData != null;
        }

        protected TextureData createIconTextureData() {
            try {
                IconSource iconSource = (IconSource)this.getImageSource();
                BufferedImage bufferedImage = iconSource.getRetriever().createIcon(iconSource.getSymbolId(), iconSource.getRetrieverParams());
                if (bufferedImage == null) {
                    this.textureInitializationFailed = true;
                    return null;
                }
                return TextureIO.newTextureData(bufferedImage, this.isUseMipMaps());
            }
            catch (Exception exception) {
                String string = Logging.getMessage("Symbology.ExceptionRetrievingTacticalIcon", this.getImageSource());
                Logging.logger().log(Level.SEVERE, string, exception);
                this.textureInitializationFailed = true;
                return null;
            }
        }

        @Override
        protected Runnable createRequestTask() {
            return new IconRequestTask(this);
        }

        protected static class IconRequestTask
        implements Runnable {
            protected final IconTexture texture;

            protected IconRequestTask(IconTexture iconTexture) {
                if (iconTexture == null) {
                    String string = Logging.getMessage("nullValue.TextureIsNull");
                    Logging.logger().severe(string);
                    throw new IllegalArgumentException(string);
                }
                this.texture = iconTexture;
            }

            @Override
            public void run() {
                if (Thread.currentThread().isInterrupted()) {
                    return;
                }
                if (this.texture.loadTextureData()) {
                    this.texture.notifyTextureLoaded();
                }
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                IconRequestTask iconRequestTask = (IconRequestTask)object;
                return this.texture != null ? this.texture.equals(iconRequestTask.texture) : iconRequestTask.texture == null;
            }

            public int hashCode() {
                return this.texture != null ? this.texture.hashCode() : 0;
            }

            public String toString() {
                return this.texture.getImageSource().toString();
            }
        }
    }

    protected static class IconSource {
        protected IconRetriever retriever;
        protected String symbolId;
        protected AVList retrieverParams;

        public IconSource(IconRetriever iconRetriever, String string, AVList aVList) {
            this.retriever = iconRetriever;
            this.symbolId = string;
            if (aVList != null) {
                this.retrieverParams = new AVListImpl();
                this.retrieverParams.setValues(aVList);
            }
        }

        public IconRetriever getRetriever() {
            return this.retriever;
        }

        public String getSymbolId() {
            return this.symbolId;
        }

        public AVList getRetrieverParams() {
            return this.retrieverParams;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            IconSource iconSource = (IconSource)object;
            if (this.retriever != null ? !this.retriever.equals(iconSource.retriever) : iconSource.retriever != null) {
                return false;
            }
            if (this.symbolId != null ? !this.symbolId.equals(iconSource.symbolId) : iconSource.symbolId != null) {
                return false;
            }
            if (this.retrieverParams != null && iconSource.retrieverParams != null) {
                Set<Map.Entry<String, Object>> set = this.retrieverParams.getEntries();
                Set<Map.Entry<String, Object>> set2 = iconSource.retrieverParams.getEntries();
                return ((Object)set).equals(set2);
            }
            return this.retrieverParams == null && iconSource.retrieverParams == null;
        }

        public int hashCode() {
            int n = this.retriever != null ? this.retriever.hashCode() : 0;
            n = 31 * n + (this.symbolId != null ? this.symbolId.hashCode() : 0);
            n = 31 * n + (this.retrieverParams != null ? ((Object)this.retrieverParams.getEntries()).hashCode() : 0);
            return n;
        }

        public String toString() {
            return this.symbolId;
        }
    }
}

