/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render.airspaces.editor;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPoint;
import gov.nasa.worldwind.render.airspaces.editor.AirspaceControlPointRenderer;
import gov.nasa.worldwind.render.markers.BasicMarker;
import gov.nasa.worldwind.render.markers.BasicMarkerAttributes;
import gov.nasa.worldwind.render.markers.Marker;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Point;
import java.util.Comparator;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.media.opengl.GL;

public class BasicAirspaceControlPointRenderer
implements AirspaceControlPointRenderer {
    private boolean enableLighting;
    private Marker controlPointMarker;
    private Material lightMaterial;
    private Vec4 lightDirection;
    private boolean enableDepthTest;
    private double maxMarkerSize;
    private PickSupport pickSupport = new PickSupport();

    public BasicAirspaceControlPointRenderer(Marker marker) {
        if (marker == null) {
            String string = Logging.getMessage("nullValue.MarkerIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.enableLighting = true;
        this.controlPointMarker = marker;
        this.lightMaterial = Material.WHITE;
        this.lightDirection = new Vec4(1.0, 0.5, 1.0);
        this.enableDepthTest = true;
    }

    public BasicAirspaceControlPointRenderer() {
        this(BasicAirspaceControlPointRenderer.createDefaultMarker());
    }

    public static Marker createDefaultMarker() {
        BasicMarkerAttributes basicMarkerAttributes = new BasicMarkerAttributes(Material.BLUE, "gov.nasa.worldwind.render.markers.Sphere", 1.0, 16.0, 0.1);
        return new BasicMarker(null, basicMarkerAttributes, null);
    }

    public boolean isEnableLighting() {
        return this.enableLighting;
    }

    public void setEnableLighting(boolean bl) {
        this.enableLighting = bl;
    }

    public Marker getControlPointMarker() {
        return this.controlPointMarker;
    }

    public void setControlPointMarker(Marker marker) {
        if (marker == null) {
            String string = Logging.getMessage("nullValue.MarkerIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.controlPointMarker = marker;
    }

    public Material getLightMaterial() {
        return this.lightMaterial;
    }

    public void setLightMaterial(Material material) {
        if (material != null) {
            String string = Logging.getMessage("nullValue.MaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lightMaterial = material;
    }

    public Vec4 getLightDirection() {
        return this.lightDirection;
    }

    public void setLightDirection(Vec4 vec4) {
        if (vec4 != null) {
            String string = Logging.getMessage("nullValue.DirectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.lightDirection = vec4;
    }

    public boolean isEnableDepthTest() {
        return this.enableDepthTest;
    }

    public void setEnableDepthTest(boolean bl) {
        this.enableDepthTest = bl;
    }

    @Override
    public void render(DrawContext drawContext, Iterable<? extends AirspaceControlPoint> iterable) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.draw(drawContext, iterable);
    }

    @Override
    public void pick(DrawContext drawContext, Iterable<? extends AirspaceControlPoint> iterable, Point point, Layer layer) {
        if (drawContext == null) {
            String string = Logging.getMessage("nullValue.DrawContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.IterableIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.pickSupport.clearPickList();
        this.draw(drawContext, iterable);
        this.pickSupport.resolvePick(drawContext, point, layer);
        this.pickSupport.clearPickList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void draw(DrawContext drawContext, Iterable<? extends AirspaceControlPoint> iterable) {
        this.begin(drawContext);
        try {
            this.drawControlPoints(drawContext, iterable);
        }
        finally {
            this.end(drawContext);
        }
    }

    protected void drawControlPoints(DrawContext drawContext, Iterable<? extends AirspaceControlPoint> iterable) {
        SortedSet<AirspaceControlPoint> sortedSet = this.sortControlPoints(drawContext, iterable);
        this.drawMarkers(drawContext, sortedSet);
    }

    protected void begin(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        if (drawContext.isPickingMode()) {
            this.pickSupport.beginPicking(drawContext);
            gL.glPushAttrib(4353);
        } else {
            gL.glPushAttrib(53569);
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            if (this.isEnableLighting()) {
                this.setupLighting(drawContext);
            }
            gL.glEnable(2977);
            gL.glHint(3152, 4354);
        }
        if (this.isEnableDepthTest()) {
            gL.glEnable(2929);
        } else {
            gL.glDisable(2929);
        }
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
    }

    protected void end(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glPopMatrix();
        gL.glPopAttrib();
        if (drawContext.isPickingMode()) {
            this.pickSupport.endPicking(drawContext);
        }
    }

    protected PickSupport getPickSupport() {
        return this.pickSupport;
    }

    protected void drawMarkers(DrawContext drawContext, Iterable<? extends AirspaceControlPoint> iterable) {
        this.setMaxMarkerSize(this.computeMaxMarkerSize(iterable));
        if (!drawContext.isPickingMode()) {
            if (this.isEnableLighting()) {
                this.getControlPointMarker().getAttributes().apply(drawContext);
            } else {
                Object object = new float[4];
                Color object2 = this.getControlPointMarker().getAttributes().getMaterial().getDiffuse();
                object2.getRGBComponents((float[])object);
                drawContext.getGL().glColor4fv((float[])object, 0);
            }
        }
        for (AirspaceControlPoint airspaceControlPoint : iterable) {
            this.drawMarker(drawContext, airspaceControlPoint);
        }
    }

    protected void drawMarker(DrawContext drawContext, AirspaceControlPoint airspaceControlPoint) {
        Object object;
        if (!drawContext.getView().getFrustumInModelCoordinates().contains(airspaceControlPoint.getPoint())) {
            return;
        }
        if (drawContext.isPickingMode()) {
            object = drawContext.getUniquePickColor();
            int n = ((Color)object).getRGB();
            PickedObject pickedObject = new PickedObject(n, airspaceControlPoint);
            this.pickSupport.addPickableObject(pickedObject);
            drawContext.getGL().glColor3ub((byte)((Color)object).getRed(), (byte)((Color)object).getGreen(), (byte)((Color)object).getBlue());
        }
        object = airspaceControlPoint.getPoint();
        double d = this.computeMarkerRadius(drawContext, this.getControlPointMarker(), (Vec4)object);
        this.getControlPointMarker().render(drawContext, (Vec4)object, d);
    }

    protected double getMaxMarkerSize() {
        return this.maxMarkerSize;
    }

    protected void setMaxMarkerSize(double d) {
        this.maxMarkerSize = d;
    }

    protected double computeMarkerRadius(DrawContext drawContext, Marker marker, Vec4 vec4) {
        double d = drawContext.getView().getEyePoint().distanceTo3(vec4);
        double d2 = marker.getAttributes().getMarkerPixels() * drawContext.getView().computePixelSizeAtDistance(d);
        if (d2 < marker.getAttributes().getMinMarkerSize()) {
            d2 = marker.getAttributes().getMinMarkerSize();
        }
        if (this.getMaxMarkerSize() > 0.0 && d2 > this.getMaxMarkerSize()) {
            d2 = this.getMaxMarkerSize();
        }
        return d2;
    }

    protected double computeMaxMarkerSize(Iterable<? extends AirspaceControlPoint> iterable) {
        double d = 0.0;
        int n = 0;
        for (AirspaceControlPoint airspaceControlPoint : iterable) {
            for (AirspaceControlPoint airspaceControlPoint2 : iterable) {
                if (airspaceControlPoint == airspaceControlPoint2) continue;
                double d2 = airspaceControlPoint.getPoint().distanceTo3(airspaceControlPoint2.getPoint());
                d += d2;
                ++n;
            }
        }
        return n == 0 ? 0.0 : d / (double)n / 16.0;
    }

    protected void setupLighting(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        gL.glEnable(2896);
        gL.glLightModelfv(2899, fArray, 0);
        gL.glLightModeli(2897, 1);
        gL.glLightModeli(2898, 0);
        gL.glShadeModel(7425);
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        float[] fArray4 = new float[4];
        this.getLightMaterial().getDiffuse().getRGBColorComponents(fArray3);
        this.getLightMaterial().getSpecular().getRGBColorComponents(fArray4);
        fArray4[3] = 0.0f;
        fArray3[3] = 0.0f;
        fArray2[3] = 0.0f;
        gL.glEnable(16384);
        gL.glLightfv(16384, 4608, fArray2, 0);
        gL.glLightfv(16384, 4609, fArray3, 0);
        gL.glLightfv(16384, 4610, fArray4, 0);
        Vec4 vec4 = this.getLightDirection().normalize3();
        float[] fArray5 = new float[]{(float)vec4.x, (float)vec4.y, (float)vec4.z, 0.0f};
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glLightfv(16384, 4611, fArray5, 0);
        gL.glPopMatrix();
    }

    protected SortedSet<AirspaceControlPoint> sortControlPoints(DrawContext drawContext, Iterable<? extends AirspaceControlPoint> iterable) {
        final Vec4 vec4 = drawContext.getView().getEyePoint();
        TreeSet<AirspaceControlPoint> treeSet = new TreeSet<AirspaceControlPoint>(new Comparator<AirspaceControlPoint>(){

            @Override
            public int compare(AirspaceControlPoint airspaceControlPoint, AirspaceControlPoint airspaceControlPoint2) {
                double d = airspaceControlPoint.getPoint().distanceTo3(vec4);
                double d2 = airspaceControlPoint2.getPoint().distanceTo3(vec4);
                int n = airspaceControlPoint.getAltitudeIndex();
                int n2 = airspaceControlPoint2.getAltitudeIndex();
                if (n2 < n) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                if (d < d2) {
                    return 1;
                }
                if (d > d2) {
                    return -1;
                }
                return 0;
            }
        });
        for (AirspaceControlPoint airspaceControlPoint : iterable) {
            treeSet.add(airspaceControlPoint);
        }
        return treeSet;
    }
}

