/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Movable;
import gov.nasa.worldwind.avlist.AVListImpl;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.BasicWWTexture;
import gov.nasa.worldwind.render.WWIcon;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.RestorableSupport;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.util.Map;

public class UserFacingIcon
extends AVListImpl
implements WWIcon,
Movable {
    private Position iconPosition;
    private Dimension iconSize;
    private boolean isHighlighted = false;
    private boolean isVisible = true;
    private double highlightScale = 1.2;
    private String toolTipText;
    private Font toolTipFont;
    private Vec4 toolTipOffset;
    private boolean showToolTip = false;
    private boolean alwaysOnTop = false;
    private Color textColor;
    private double backgroundScale;
    protected BasicWWTexture imageTexture;
    protected BasicWWTexture backgroundTexture;

    public UserFacingIcon() {
    }

    public UserFacingIcon(String string, Position position) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.IconFilePath");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.imageTexture = new BasicWWTexture(string, true);
        this.imageTexture.setUseAnisotropy(false);
        this.iconPosition = position;
    }

    public UserFacingIcon(Object object, Position position) {
        if (object == null) {
            String string = Logging.getMessage("nullValue.IconFilePath");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.imageTexture = new BasicWWTexture(object, true);
        this.imageTexture.setUseAnisotropy(false);
        this.iconPosition = position;
    }

    @Override
    public BasicWWTexture getImageTexture() {
        return this.imageTexture;
    }

    @Override
    public BasicWWTexture getBackgroundTexture() {
        return this.backgroundTexture;
    }

    @Override
    public Object getImageSource() {
        return this.getImageTexture() != null ? this.getImageTexture().getImageSource() : null;
    }

    @Override
    public void setImageSource(Object object) {
        this.imageTexture = new BasicWWTexture(object, true);
        this.imageTexture.setUseAnisotropy(false);
    }

    public String getPath() {
        return this.getImageSource() instanceof String ? (String)this.getImageSource() : null;
    }

    @Override
    public Position getPosition() {
        return this.iconPosition;
    }

    @Override
    public void setPosition(Position position) {
        this.iconPosition = position;
    }

    @Override
    public boolean isHighlighted() {
        return this.isHighlighted;
    }

    @Override
    public void setHighlighted(boolean bl) {
        this.isHighlighted = bl;
    }

    @Override
    public double getHighlightScale() {
        return this.highlightScale;
    }

    @Override
    public void setHighlightScale(double d) {
        this.highlightScale = d;
    }

    @Override
    public Dimension getSize() {
        return this.iconSize;
    }

    @Override
    public void setSize(Dimension dimension) {
        this.iconSize = dimension;
    }

    @Override
    public boolean isVisible() {
        return this.isVisible;
    }

    @Override
    public void setVisible(boolean bl) {
        this.isVisible = bl;
    }

    @Override
    public String getToolTipText() {
        return this.toolTipText;
    }

    @Override
    public void setToolTipText(String string) {
        this.toolTipText = string;
    }

    @Override
    public Font getToolTipFont() {
        return this.toolTipFont;
    }

    @Override
    public void setToolTipFont(Font font) {
        this.toolTipFont = font;
    }

    @Override
    public Vec4 getToolTipOffset() {
        return this.toolTipOffset;
    }

    @Override
    public void setToolTipOffset(Vec4 vec4) {
        this.toolTipOffset = vec4;
    }

    @Override
    public boolean isShowToolTip() {
        return this.showToolTip;
    }

    @Override
    public void setShowToolTip(boolean bl) {
        this.showToolTip = bl;
    }

    @Override
    public Color getToolTipTextColor() {
        return this.textColor;
    }

    @Override
    public void setToolTipTextColor(Color color) {
        this.textColor = color;
    }

    @Override
    public boolean isAlwaysOnTop() {
        return this.alwaysOnTop;
    }

    @Override
    public void setAlwaysOnTop(boolean bl) {
        this.alwaysOnTop = bl;
    }

    @Override
    public Object getBackgroundImage() {
        return this.getBackgroundTexture() != null ? this.getBackgroundTexture().getImageSource() : null;
    }

    @Override
    public void setBackgroundImage(Object object) {
        if (object != null) {
            this.backgroundTexture = new BasicWWTexture(object, true);
            this.backgroundTexture.setUseAnisotropy(false);
        } else {
            this.backgroundTexture = null;
        }
    }

    @Override
    public double getBackgroundScale() {
        return this.backgroundScale;
    }

    @Override
    public void setBackgroundScale(double d) {
        this.backgroundScale = d;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.iconPosition = this.iconPosition.add(position);
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.iconPosition = position;
    }

    @Override
    public Position getReferencePosition() {
        return this.iconPosition;
    }

    public String toString() {
        return this.getImageSource() != null ? this.getImageSource().toString() : this.getClass().getName();
    }

    @Override
    public String getRestorableState() {
        Object object;
        RestorableSupport restorableSupport = RestorableSupport.newRestorableSupport();
        if (restorableSupport == null) {
            return null;
        }
        if (this.getPath() != null) {
            restorableSupport.addStateValueAsString("imagePath", this.getPath(), true);
        }
        if (this.iconPosition != null && this.iconPosition.getLatitude() != null && this.iconPosition.getLongitude() != null && (object = restorableSupport.addStateObject("position")) != null) {
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "latitude", this.iconPosition.getLatitude().degrees);
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "longitude", this.iconPosition.getLongitude().degrees);
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "elevation", this.iconPosition.getElevation());
        }
        if (this.iconSize != null && (object = restorableSupport.addStateObject("size")) != null) {
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "width", this.iconSize.getWidth());
            restorableSupport.addStateValueAsDouble((RestorableSupport.StateObject)object, "height", this.iconSize.getHeight());
        }
        if (this.toolTipText != null) {
            restorableSupport.addStateValueAsString("toolTipText", this.toolTipText, true);
        }
        if (this.toolTipFont != null && (object = restorableSupport.addStateObject("toolTipFont")) != null) {
            restorableSupport.addStateValueAsString((RestorableSupport.StateObject)object, "name", this.toolTipFont.getName());
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "style", this.toolTipFont.getStyle());
            restorableSupport.addStateValueAsInteger((RestorableSupport.StateObject)object, "size", this.toolTipFont.getSize());
        }
        if (this.textColor != null && (object = RestorableSupport.encodeColor(this.textColor)) != null) {
            restorableSupport.addStateValueAsString("toolTipTextColor", (String)object);
        }
        if (this.getBackgroundTexture() != null && this.getBackgroundTexture().getImageSource() instanceof String) {
            object = (String)this.getBackgroundTexture().getImageSource();
            restorableSupport.addStateValueAsString("backgroundImagePath", (String)object, true);
        }
        restorableSupport.addStateValueAsBoolean("highlighted", this.isHighlighted);
        restorableSupport.addStateValueAsDouble("highlightScale", this.highlightScale);
        restorableSupport.addStateValueAsBoolean("visible", this.isVisible);
        restorableSupport.addStateValueAsBoolean("showToolTip", this.showToolTip);
        restorableSupport.addStateValueAsBoolean("alwaysOnTop", this.alwaysOnTop);
        restorableSupport.addStateValueAsDouble("backgroundScale", this.backgroundScale);
        object = restorableSupport.addStateObject(null, "avlist");
        for (Map.Entry<String, Object> entry : this.getEntries()) {
            this.getRestorableStateForAVPair(entry.getKey(), entry.getValue() != null ? entry.getValue() : "", restorableSupport, (RestorableSupport.StateObject)object);
        }
        return restorableSupport.getStateAsXml();
    }

    @Override
    public void restoreState(String string) {
        Number number;
        Number number2;
        Object object;
        RestorableSupport.StateObject stateObject;
        RestorableSupport restorableSupport;
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.StringIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        try {
            restorableSupport = RestorableSupport.parse(string);
        }
        catch (Exception exception) {
            String string3 = Logging.getMessage("generic.ExceptionAttemptingToParseStateXml", string);
            Logging.logger().severe(string3);
            throw new IllegalArgumentException(string3, exception);
        }
        String string4 = restorableSupport.getStateValueAsString("imagePath");
        if (string4 != null) {
            this.setImageSource(string4);
        }
        if ((stateObject = restorableSupport.getStateObject("position")) != null) {
            object = restorableSupport.getStateValueAsDouble(stateObject, "latitude");
            number2 = restorableSupport.getStateValueAsDouble(stateObject, "longitude");
            number = restorableSupport.getStateValueAsDouble(stateObject, "elevation");
            if (object != null && number2 != null && number != null) {
                this.setPosition(Position.fromDegrees((Double)object, (Double)number2, (Double)number));
            }
        }
        if ((stateObject = restorableSupport.getStateObject("size")) != null) {
            object = restorableSupport.getStateValueAsDouble(stateObject, "width");
            number2 = restorableSupport.getStateValueAsDouble(stateObject, "height");
            if (object != null && number2 != null) {
                this.setSize(new Dimension(((Double)object).intValue(), ((Double)number2).intValue()));
            }
        }
        if ((string4 = restorableSupport.getStateValueAsString("toolTipText")) != null) {
            this.setToolTipText(string4);
        }
        if ((stateObject = restorableSupport.getStateObject("toolTipFont")) != null) {
            object = restorableSupport.getStateValueAsString(stateObject, "name");
            number2 = restorableSupport.getStateValueAsInteger(stateObject, "style");
            number = restorableSupport.getStateValueAsInteger(stateObject, "size");
            if (object != null && number2 != null && number != null) {
                this.setToolTipFont(new Font((String)object, ((Integer)number2).intValue(), (Integer)number));
            }
        }
        if ((string4 = restorableSupport.getStateValueAsString("toolTipTextColor")) != null && (object = RestorableSupport.decodeColor(string4)) != null) {
            this.setToolTipTextColor((Color)object);
        }
        if ((string4 = restorableSupport.getStateValueAsString("backgroundImagePath")) != null) {
            this.setBackgroundImage(string4);
        }
        if ((object = restorableSupport.getStateValueAsBoolean("highlighted")) != null) {
            this.setHighlighted((Boolean)object);
        }
        if ((number2 = restorableSupport.getStateValueAsDouble("highlightScale")) != null) {
            this.setHighlightScale((Double)number2);
        }
        if ((object = restorableSupport.getStateValueAsBoolean("visible")) != null) {
            this.setVisible((Boolean)object);
        }
        if ((object = restorableSupport.getStateValueAsBoolean("showToolTip")) != null) {
            this.setShowToolTip((Boolean)object);
        }
        if ((object = restorableSupport.getStateValueAsBoolean("alwaysOnTop")) != null) {
            this.setAlwaysOnTop((Boolean)object);
        }
        if ((number2 = restorableSupport.getStateValueAsDouble("backgroundScale")) != null) {
            this.setBackgroundScale((Double)number2);
        }
        if ((stateObject = restorableSupport.getStateObject(null, "avlist")) != null && (number = restorableSupport.getAllStateObjects(stateObject, "")) != null) {
            for (Number number3 : number) {
                if (number3 == null) continue;
                this.setValue(((RestorableSupport.StateObject)((Object)number3)).getName(), ((RestorableSupport.StateObject)((Object)number3)).getValue());
            }
        }
    }
}

