/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import com.sun.opengl.util.BufferUtil;
import gov.nasa.worldwind.cache.ShapeDataCache;
import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.Box;
import gov.nasa.worldwind.geom.Cylinder;
import gov.nasa.worldwind.geom.Extent;
import gov.nasa.worldwind.geom.Frustum;
import gov.nasa.worldwind.geom.Intersection;
import gov.nasa.worldwind.geom.LatLon;
import gov.nasa.worldwind.geom.Line;
import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.geom.Sector;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.layers.Layer;
import gov.nasa.worldwind.ogc.kml.impl.KMLExportUtil;
import gov.nasa.worldwind.pick.PickSupport;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.render.AbstractShape;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.render.ShapeAttributes;
import gov.nasa.worldwind.terrain.Terrain;
import gov.nasa.worldwind.util.BufferWrapper;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWMath;
import gov.nasa.worldwind.util.WWUtil;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.media.opengl.GL;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

public class Path
extends AbstractShape {
    protected static final Material DEFAULT_INTERIOR_MATERIAL = Material.PINK;
    protected static final Material DEFAULT_OUTLINE_MATERIAL = Material.RED;
    protected static final String DEFAULT_PATH_TYPE = "gov.nasa.worldwind.avkey.Linear";
    protected static final double SURFACE_PATH_DEPTH_OFFSET = 0.99;
    protected static final int DEFAULT_NUM_SUBSEGMENTS = 10;
    protected static final double DEFAULT_TERRAIN_CONFORMANCE = 10.0;
    protected static final double DEFAULT_DRAW_POSITIONS_THRESHOLD = 1000000.0;
    protected static final double DEFAULT_DRAW_POSITIONS_SCALE = 10.0;
    protected Iterable<? extends Position> positions;
    protected int numPositions;
    protected PositionColors positionColors;
    protected static ByteBuffer pickPositionColors;
    protected String pathType = "gov.nasa.worldwind.avkey.Linear";
    protected boolean followTerrain;
    protected boolean extrude;
    protected double terrainConformance = 10.0;
    protected int numSubsegments = 10;
    protected boolean drawVerticals = true;
    protected boolean showPositions = false;
    protected double showPositionsThreshold = 1000000.0;
    protected double showPositionsScale = 10.0;

    @Override
    protected AbstractShape.AbstractShapeData createCacheEntry(DrawContext drawContext) {
        return new PathData(drawContext, this);
    }

    protected PathData getCurrentPathData() {
        return (PathData)this.getCurrentData();
    }

    public Path() {
    }

    public Path(Iterable<? extends Position> iterable) {
        this.setPositions(iterable);
    }

    public Path(Position.PositionList positionList) {
        if (positionList == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.setPositions(positionList.list);
    }

    public Path(Position position, Position position2) {
        if (position == null || position2 == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        ArrayList<Position> arrayList = new ArrayList<Position>(2);
        arrayList.add(position);
        arrayList.add(position2);
        this.setPositions(arrayList);
    }

    @Override
    protected void initialize() {
        this.pickSupport = new PathPickSupport();
    }

    @Override
    protected void reset() {
        for (ShapeDataCache.ShapeDataCacheEntry shapeDataCacheEntry : this.shapeDataCache) {
            ((PathData)shapeDataCacheEntry).tessellatedPositions = null;
            ((PathData)shapeDataCacheEntry).tessellatedColors = null;
        }
        super.reset();
    }

    public Iterable<? extends Position> getPositions() {
        return this.positions;
    }

    public void setPositions(Iterable<? extends Position> iterable) {
        if (iterable == null) {
            String string = Logging.getMessage("nullValue.PositionsListIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.positions = iterable;
        this.computePositionCount();
        this.reset();
    }

    public PositionColors getPositionColors() {
        return this.positionColors;
    }

    public void setPositionColors(PositionColors positionColors) {
        this.positionColors = positionColors;
        this.reset();
    }

    public boolean isExtrude() {
        return this.extrude;
    }

    public void setExtrude(boolean bl) {
        this.extrude = bl;
        this.reset();
    }

    public boolean isFollowTerrain() {
        return this.followTerrain;
    }

    public void setFollowTerrain(boolean bl) {
        if (this.followTerrain == bl) {
            return;
        }
        this.followTerrain = bl;
        this.reset();
    }

    public int getNumSubsegments() {
        return this.numSubsegments;
    }

    public void setNumSubsegments(int n) {
        this.numSubsegments = n;
        this.reset();
    }

    public double getTerrainConformance() {
        return this.terrainConformance;
    }

    public void setTerrainConformance(double d) {
        this.terrainConformance = d;
        this.reset();
    }

    public String getPathType() {
        return this.pathType;
    }

    public void setPathType(String string) {
        this.pathType = string;
        this.reset();
    }

    public boolean isDrawVerticals() {
        return this.drawVerticals;
    }

    public void setDrawVerticals(boolean bl) {
        this.drawVerticals = bl;
        this.reset();
    }

    public boolean isShowPositions() {
        return this.showPositions;
    }

    public void setShowPositions(boolean bl) {
        this.showPositions = bl;
    }

    public double getShowPositionsScale() {
        return this.showPositionsScale;
    }

    public void setShowPositionsScale(double d) {
        this.showPositionsScale = d;
    }

    public double getShowPositionsThreshold() {
        return this.showPositionsThreshold;
    }

    public void setShowPositionsThreshold(double d) {
        this.showPositionsThreshold = d;
    }

    @Override
    public Sector getSector() {
        if (this.sector == null && this.positions != null) {
            this.sector = Sector.boundingSector(this.positions);
        }
        return this.sector;
    }

    @Override
    protected boolean mustDrawInterior() {
        return super.mustDrawInterior() && this.getCurrentPathData().hasExtrusionPoints;
    }

    @Override
    protected boolean mustApplyLighting(DrawContext drawContext, ShapeAttributes shapeAttributes) {
        return false;
    }

    @Override
    protected boolean mustApplyTexture(DrawContext drawContext) {
        return false;
    }

    @Override
    protected boolean mustRegenerateGeometry(DrawContext drawContext) {
        if (this.getCurrentPathData() == null || this.getCurrentPathData().renderedPath == null) {
            return true;
        }
        if (this.getCurrentPathData().tessellatedPositions == null) {
            return true;
        }
        if (drawContext.getVerticalExaggeration() != this.getCurrentPathData().getVerticalExaggeration()) {
            return true;
        }
        return super.mustRegenerateGeometry(drawContext);
    }

    @Override
    protected boolean shouldUseVBOs(DrawContext drawContext) {
        return this.getCurrentPathData().tessellatedPositions.size() > VBO_THRESHOLD && super.shouldUseVBOs(drawContext);
    }

    protected boolean isSurfacePath() {
        return this.getAltitudeMode() == 1 && this.isFollowTerrain();
    }

    @Override
    protected void determineActiveAttributes() {
        boolean bl = this.activeAttributes.isDrawInterior();
        super.determineActiveAttributes();
        if (this.activeAttributes != null && this.activeAttributes.isDrawInterior() != bl) {
            this.getCurrentData().setExpired(true);
        }
    }

    protected void computePositionCount() {
        this.numPositions = 0;
        if (this.positions != null) {
            for (Position position : this.positions) {
                ++this.numPositions;
            }
        }
    }

    @Override
    protected boolean doMakeOrderedRenderable(DrawContext drawContext) {
        PathData pathData = this.getCurrentPathData();
        pathData.setReferencePoint(this.computeReferenceCenter(drawContext));
        if (pathData.getReferencePoint() == null) {
            return false;
        }
        this.makeTessellatedPositions(drawContext, pathData);
        if (pathData.tessellatedPositions == null || pathData.tessellatedPositions.size() < 2) {
            return false;
        }
        int n = pathData.renderedPath != null ? pathData.renderedPath.limit() : 0;
        this.computePath(drawContext, pathData.tessellatedPositions, pathData);
        if (pathData.renderedPath == null || pathData.renderedPath.limit() < 6) {
            return false;
        }
        if (pathData.renderedPath.limit() > n && this.shouldUseVBOs(drawContext)) {
            this.clearCachedVbos(drawContext);
        }
        pathData.setExtent(this.computeExtent(pathData));
        if (this.getExtent() == null || drawContext.isSmall(this.getExtent(), 1)) {
            return false;
        }
        if (!this.intersectsFrustum(drawContext)) {
            return false;
        }
        pathData.setEyeDistance(this.computeEyeDistance(drawContext, pathData));
        pathData.setGlobeStateKey(drawContext.getGlobe().getGlobeStateKey(drawContext));
        pathData.setVerticalExaggeration(drawContext.getVerticalExaggeration());
        return true;
    }

    @Override
    protected void doDrawOrderedRenderable(DrawContext drawContext, PickSupport pickSupport) {
        if (drawContext.isPickingMode()) {
            this.addPickablePositions(drawContext, pickSupport);
        }
        super.doDrawOrderedRenderable(drawContext, pickSupport);
    }

    @Override
    protected void addOrderedRenderable(DrawContext drawContext) {
        if (this.isSurfacePath()) {
            drawContext.addOrderedRenderable(this, true);
        } else {
            super.addOrderedRenderable(drawContext);
        }
    }

    @Override
    protected boolean isOrderedRenderableValid(DrawContext drawContext) {
        return this.getCurrentPathData().renderedPath != null && this.getCurrentPathData().vertexCount >= 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDrawOutline(DrawContext drawContext) {
        boolean bl = false;
        try {
            if (this.isSurfacePath()) {
                drawContext.pushProjectionOffest(0.99);
                drawContext.getGL().glDepthMask(false);
                bl = true;
            }
            if (this.shouldUseVBOs(drawContext)) {
                int[] nArray = this.getVboIds(drawContext);
                if (nArray != null) {
                    this.doDrawOutlineVBO(drawContext, nArray, this.getCurrentPathData());
                } else {
                    this.doDrawOutlineVA(drawContext, this.getCurrentPathData());
                }
            } else {
                this.doDrawOutlineVA(drawContext, this.getCurrentPathData());
            }
        }
        finally {
            if (bl) {
                drawContext.popProjectionOffest();
                drawContext.getGL().glDepthMask(true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doDrawOutlineVBO(DrawContext drawContext, int[] nArray, PathData pathData) {
        GL gL = drawContext.getGL();
        try {
            int n = pathData.hasExtrusionPoints ? 2 * pathData.vertexStride : pathData.vertexStride;
            int n2 = pathData.hasExtrusionPoints ? pathData.vertexCount / 2 : pathData.vertexCount;
            boolean bl = !drawContext.isPickingMode() && pathData.tessellatedColors != null;
            gL.glBindBuffer(34962, nArray[0]);
            gL.glVertexPointer(3, 5126, 4 * n, 0L);
            if (bl) {
                gL.glEnableClientState(32886);
                gL.glColorPointer(4, 5126, 4 * n, 4 * pathData.colorOffset);
            }
            gL.glDrawArrays(3, 0, n2);
            if (bl) {
                gL.glDisableClientState(32886);
            }
            if (pathData.hasExtrusionPoints && this.isDrawVerticals()) {
                this.drawVerticalOutlineVBO(drawContext, nArray, pathData);
            }
            if (this.isShowPositions()) {
                this.drawPointsVBO(drawContext, nArray, pathData);
            }
        }
        finally {
            gL.glBindBuffer(34962, 0);
            gL.glBindBuffer(34963, 0);
        }
    }

    protected void doDrawOutlineVA(DrawContext drawContext, PathData pathData) {
        GL gL = drawContext.getGL();
        int n = pathData.hasExtrusionPoints ? 2 * pathData.vertexStride : pathData.vertexStride;
        int n2 = pathData.hasExtrusionPoints ? pathData.vertexCount / 2 : pathData.vertexCount;
        boolean bl = !drawContext.isPickingMode() && pathData.tessellatedColors != null;
        gL.glVertexPointer(3, 5126, 4 * n, pathData.renderedPath.rewind());
        if (bl) {
            gL.glEnableClientState(32886);
            gL.glColorPointer(4, 5126, 4 * n, pathData.renderedPath.position(pathData.colorOffset));
            pathData.renderedPath.rewind();
        }
        gL.glDrawArrays(3, 0, n2);
        if (bl) {
            gL.glDisableClientState(32886);
        }
        if (pathData.hasExtrusionPoints && this.isDrawVerticals()) {
            this.drawVerticalOutlineVA(drawContext, pathData);
        }
        if (this.isShowPositions()) {
            this.drawPointsVA(drawContext, pathData);
        }
    }

    protected void drawVerticalOutlineVBO(DrawContext drawContext, int[] nArray, PathData pathData) {
        IntBuffer intBuffer = pathData.polePositions;
        if (intBuffer == null || intBuffer.limit() < 1) {
            return;
        }
        GL gL = drawContext.getGL();
        gL.glVertexPointer(3, 5126, 4 * pathData.vertexStride, 0L);
        gL.glBindBuffer(34963, nArray[1]);
        gL.glDrawElements(1, intBuffer.limit(), 5125, 0L);
        gL.glBindBuffer(34963, 0);
    }

    protected void drawVerticalOutlineVA(DrawContext drawContext, PathData pathData) {
        IntBuffer intBuffer = pathData.polePositions;
        if (intBuffer == null || intBuffer.limit() < 1) {
            return;
        }
        drawContext.getGL().glVertexPointer(3, 5126, 4 * pathData.vertexStride, pathData.renderedPath.rewind());
        drawContext.getGL().glDrawElements(1, intBuffer.limit(), 5125, intBuffer.rewind());
    }

    protected void drawPointsVA(DrawContext drawContext, PathData pathData) {
        double d = this.getDistanceMetric(drawContext, pathData);
        if (d > this.getShowPositionsThreshold()) {
            return;
        }
        IntBuffer intBuffer = pathData.positionPoints;
        if (intBuffer == null || intBuffer.limit() < 1) {
            return;
        }
        GL gL = drawContext.getGL();
        gL.glVertexPointer(3, 5126, 4 * pathData.vertexStride, pathData.renderedPath.rewind());
        if (drawContext.isPickingMode()) {
            gL.glEnableClientState(32886);
            gL.glColorPointer(3, 5121, 0, pickPositionColors);
        } else if (pathData.tessellatedColors != null) {
            gL.glEnableClientState(32886);
            gL.glColorPointer(4, 5126, 4 * pathData.vertexStride, pathData.renderedPath.position(pathData.colorOffset));
        }
        this.prepareToDrawPoints(drawContext);
        gL.glDrawElements(0, intBuffer.limit(), 5125, intBuffer.rewind());
        gL.glPointSize(1.0f);
        gL.glDisable(2832);
        if (drawContext.isPickingMode() || pathData.tessellatedColors != null) {
            gL.glDisableClientState(32886);
        }
    }

    protected void drawPointsVBO(DrawContext drawContext, int[] nArray, PathData pathData) {
        double d = this.getDistanceMetric(drawContext, pathData);
        if (d > this.getShowPositionsThreshold()) {
            return;
        }
        IntBuffer intBuffer = pathData.positionPoints;
        if (intBuffer == null || intBuffer.limit() < 1) {
            return;
        }
        GL gL = drawContext.getGL();
        gL.glVertexPointer(3, 5126, 4 * pathData.vertexStride, 0L);
        if (drawContext.isPickingMode()) {
            gL.glEnableClientState(32886);
            gL.glBindBuffer(34962, 0);
            gL.glColorPointer(3, 5121, 0, pickPositionColors);
        } else if (pathData.tessellatedColors != null) {
            gL.glEnableClientState(32886);
            gL.glColorPointer(4, 5126, 4 * pathData.vertexStride, 4 * pathData.colorOffset);
        }
        this.prepareToDrawPoints(drawContext);
        gL.glBindBuffer(34963, nArray[2]);
        gL.glDrawElements(0, intBuffer.limit(), 5125, 0L);
        gL.glPointSize(1.0f);
        gL.glDisable(2832);
        if (drawContext.isPickingMode() || pathData.tessellatedColors != null) {
            gL.glDisableClientState(32886);
        }
    }

    protected void prepareToDrawPoints(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        if (drawContext.isPickingMode()) {
            ShapeAttributes shapeAttributes = this.getActiveAttributes();
            double d = shapeAttributes.getOutlineWidth() < (double)this.getOutlinePickWidth() ? (double)this.getOutlinePickWidth() - shapeAttributes.getOutlineWidth() : 0.0;
            gL.glPointSize((float)(this.getShowPositionsScale() * shapeAttributes.getOutlineWidth() + d));
        } else {
            gL.glPointSize((float)(this.getShowPositionsScale() * this.getActiveAttributes().getOutlineWidth()));
        }
        gL.glEnable(2832);
        gL.glHint(3153, 4354);
    }

    @Override
    protected void doDrawInterior(DrawContext drawContext) {
        if (this.shouldUseVBOs(drawContext)) {
            int[] nArray = this.getVboIds(drawContext);
            if (nArray != null) {
                this.doDrawInteriorVBO(drawContext, nArray, this.getCurrentPathData());
            } else {
                this.doDrawInteriorVA(drawContext, this.getCurrentPathData());
            }
        } else {
            this.doDrawInteriorVA(drawContext, this.getCurrentPathData());
        }
    }

    protected void doDrawInteriorVBO(DrawContext drawContext, int[] nArray, PathData pathData) {
        GL gL = drawContext.getGL();
        gL.glBindBuffer(34962, nArray[0]);
        gL.glVertexPointer(3, 5126, 4 * pathData.vertexStride, 0L);
        gL.glDrawArrays(5, 0, pathData.vertexCount);
        gL.glBindBuffer(34962, 0);
    }

    protected void doDrawInteriorVA(DrawContext drawContext, PathData pathData) {
        drawContext.getGL().glVertexPointer(3, 5126, 4 * pathData.vertexStride, pathData.renderedPath.rewind());
        drawContext.getGL().glDrawArrays(5, 0, pathData.vertexCount);
    }

    protected void computePath(DrawContext drawContext, List<Position> list, PathData pathData) {
        pathData.hasExtrusionPoints = false;
        FloatBuffer floatBuffer = pathData.renderedPath;
        floatBuffer = this.getAltitudeMode() == 1 ? this.computePointsRelativeToTerrain(drawContext, list, 0.0, floatBuffer, pathData) : (this.getAltitudeMode() == 2 ? this.computePointsRelativeToTerrain(drawContext, list, null, floatBuffer, pathData) : this.computeAbsolutePoints(drawContext, list, floatBuffer, pathData));
        floatBuffer.flip();
        pathData.renderedPath = floatBuffer;
        pathData.vertexCount = floatBuffer.limit() / pathData.vertexStride;
    }

    protected FloatBuffer computePointsRelativeToTerrain(DrawContext drawContext, List<Position> list, Double d, FloatBuffer floatBuffer, PathData pathData) {
        float[] fArray;
        boolean bl = this.isExtrude() && (d == null || d != 0.0);
        int n = bl ? 2 * list.size() : list.size();
        int n2 = pathData.tessellatedColors != null ? 7 : 3;
        Iterator<Color> iterator = pathData.tessellatedColors != null ? pathData.tessellatedColors.iterator() : null;
        float[] fArray2 = fArray = pathData.tessellatedColors != null ? new float[4] : null;
        if (floatBuffer == null || floatBuffer.capacity() < n2 * n) {
            floatBuffer = BufferUtil.newFloatBuffer(n2 * n);
        }
        floatBuffer.clear();
        for (Position position : list) {
            double d2 = d != null ? d.doubleValue() : position.getAltitude();
            Vec4 vec4 = pathData.getReferencePoint();
            Vec4 vec42 = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), d2);
            floatBuffer.put((float)(vec42.x - vec4.x));
            floatBuffer.put((float)(vec42.y - vec4.y));
            floatBuffer.put((float)(vec42.z - vec4.z));
            if (iterator != null && iterator.hasNext()) {
                iterator.next().getRGBComponents(fArray);
                floatBuffer.put(fArray);
            }
            if (!bl) continue;
            this.appendTerrainPoint(drawContext, position, fArray, floatBuffer, pathData);
        }
        pathData.colorOffset = pathData.tessellatedColors != null ? 3 : 0;
        pathData.vertexStride = n2;
        return floatBuffer;
    }

    protected FloatBuffer computeAbsolutePoints(DrawContext drawContext, List<Position> list, FloatBuffer floatBuffer, PathData pathData) {
        float[] fArray;
        int n = this.isExtrude() ? 2 * list.size() : list.size();
        int n2 = pathData.tessellatedColors != null ? 7 : 3;
        Iterator<Color> iterator = pathData.tessellatedColors != null ? pathData.tessellatedColors.iterator() : null;
        float[] fArray2 = fArray = pathData.tessellatedColors != null ? new float[4] : null;
        if (floatBuffer == null || floatBuffer.capacity() < n2 * n) {
            floatBuffer = BufferUtil.newFloatBuffer(n2 * n);
        }
        floatBuffer.clear();
        Globe globe = drawContext.getGlobe();
        Vec4 vec4 = pathData.getReferencePoint();
        if (drawContext.getVerticalExaggeration() != 1.0) {
            double d = drawContext.getVerticalExaggeration();
            for (Position position : list) {
                Vec4 vec42 = globe.computePointFromPosition(position.getLatitude(), position.getLongitude(), d * position.getAltitude());
                floatBuffer.put((float)(vec42.x - vec4.x));
                floatBuffer.put((float)(vec42.y - vec4.y));
                floatBuffer.put((float)(vec42.z - vec4.z));
                if (iterator != null && iterator.hasNext()) {
                    iterator.next().getRGBComponents(fArray);
                    floatBuffer.put(fArray);
                }
                if (!this.isExtrude()) continue;
                this.appendTerrainPoint(drawContext, position, fArray, floatBuffer, pathData);
            }
        } else {
            for (Position position : list) {
                Vec4 vec43 = globe.computePointFromPosition(position);
                floatBuffer.put((float)(vec43.x - vec4.x));
                floatBuffer.put((float)(vec43.y - vec4.y));
                floatBuffer.put((float)(vec43.z - vec4.z));
                if (iterator != null && iterator.hasNext()) {
                    iterator.next().getRGBComponents(fArray);
                    floatBuffer.put(fArray);
                }
                if (!this.isExtrude()) continue;
                this.appendTerrainPoint(drawContext, position, fArray, floatBuffer, pathData);
            }
        }
        pathData.colorOffset = pathData.tessellatedColors != null ? 3 : 0;
        pathData.vertexStride = n2;
        return floatBuffer;
    }

    protected void appendTerrainPoint(DrawContext drawContext, Position position, float[] fArray, FloatBuffer floatBuffer, PathData pathData) {
        Vec4 vec4 = pathData.getReferencePoint();
        Vec4 vec42 = drawContext.computeTerrainPoint(position.getLatitude(), position.getLongitude(), 0.0);
        floatBuffer.put((float)(vec42.x - vec4.x));
        floatBuffer.put((float)(vec42.y - vec4.y));
        floatBuffer.put((float)(vec42.z - vec4.z));
        if (fArray != null) {
            floatBuffer.put(fArray);
        }
        pathData.hasExtrusionPoints = true;
    }

    protected void addPickablePositions(DrawContext drawContext, PickSupport pickSupport) {
        int n;
        if (!this.isShowPositions()) {
            return;
        }
        PathData pathData = this.getCurrentPathData();
        double d = this.getDistanceMetric(drawContext, pathData);
        if (d > this.getShowPositionsThreshold()) {
            return;
        }
        IntBuffer intBuffer = pathData.positionPoints;
        if (intBuffer == null || intBuffer.limit() < 1) {
            return;
        }
        if (pickPositionColors == null || pickPositionColors.capacity() < 3 * pathData.vertexCount) {
            pickPositionColors = ByteBuffer.allocateDirect(3 * pathData.vertexCount);
        }
        pickPositionColors.clear();
        intBuffer.rewind();
        intBuffer.get();
        int n2 = intBuffer.get();
        Color color = drawContext.getUniquePickColor();
        int n3 = n = color.getRGB();
        for (int i = 0; i < pathData.vertexCount; ++i) {
            if (i == n2) {
                if (intBuffer.remaining() > 0) {
                    n2 = intBuffer.get();
                }
                color = drawContext.getUniquePickColor();
                n3 = color.getRGB();
            }
            pickPositionColors.put((byte)color.getRed()).put((byte)color.getGreen()).put((byte)color.getBlue());
        }
        pickPositionColors.flip();
        intBuffer.rewind();
        ((PathPickSupport)pickSupport).addPickablePositions(n, n3, this);
    }

    protected PickedObject resolvePickedPosition(int n, int n2) {
        Integer n3;
        PickedObject pickedObject = this.createPickedObject(n);
        Position position = this.getPosition(n2);
        if (position != null) {
            pickedObject.setPosition(position);
        }
        if ((n3 = this.getOrdinal(n2)) != null) {
            pickedObject.setValue("gov.nasa.worldwind.avkey.Ordinal", n3);
        }
        return pickedObject;
    }

    protected void makeTessellatedPositions(DrawContext drawContext, PathData pathData) {
        if (this.numPositions < 2) {
            return;
        }
        if (pathData.tessellatedPositions == null || pathData.tessellatedPositions.size() < this.numPositions) {
            int n = (this.numSubsegments * (this.numPositions - 1) + 1) * (this.isExtrude() ? 2 : 1);
            pathData.tessellatedPositions = new ArrayList(n);
            pathData.tessellatedColors = this.positionColors != null ? new ArrayList(n) : null;
        } else {
            pathData.tessellatedPositions.clear();
            if (pathData.tessellatedColors != null) {
                pathData.tessellatedColors.clear();
            }
        }
        if (pathData.polePositions == null || pathData.polePositions.capacity() < this.numPositions * 2) {
            pathData.polePositions = BufferUtil.newIntBuffer(this.numPositions * 2);
        } else {
            pathData.polePositions.clear();
        }
        if (pathData.positionPoints == null || pathData.positionPoints.capacity() < this.numPositions) {
            pathData.positionPoints = BufferUtil.newIntBuffer(this.numPositions);
        } else {
            pathData.positionPoints.clear();
        }
        this.makePositions(drawContext, pathData);
        pathData.tessellatedPositions.trimToSize();
        pathData.polePositions.flip();
        pathData.positionPoints.flip();
        if (pathData.tessellatedColors != null) {
            pathData.tessellatedColors.trimToSize();
        }
    }

    protected double getDistanceMetric(DrawContext drawContext, PathData pathData) {
        return pathData.getExtent() != null ? WWMath.computeDistanceFromEye(drawContext, pathData.getExtent()) : drawContext.getView().getEyePosition().getElevation();
    }

    protected void makePositions(DrawContext drawContext, PathData pathData) {
        Iterator<? extends Position> iterator = this.positions.iterator();
        Position position = iterator.next();
        int n = 0;
        Color color = this.getColor(position, n);
        this.addTessellatedPosition(position, color, n, pathData);
        Vec4 vec4 = this.computePoint(drawContext.getTerrain(), position);
        while (iterator.hasNext()) {
            Position position2 = iterator.next();
            int n2 = n + 1;
            Color color2 = this.getColor(position2, n2);
            Vec4 vec42 = this.computePoint(drawContext.getTerrain(), position2);
            if (this.isSmall(drawContext, vec4, vec42, 8) || !this.isSegmentVisible(drawContext, position, position2, vec4, vec42)) {
                this.addTessellatedPosition(position2, color2, n2, pathData);
            } else {
                this.makeSegment(drawContext, position, position2, vec4, vec42, color, color2, n, n2, pathData);
            }
            position = position2;
            vec4 = vec42;
            n = n2;
            color = color2;
        }
    }

    protected void addTessellatedPosition(Position position, Color color, Integer n, PathData pathData) {
        if (n != null) {
            int n2 = pathData.tessellatedPositions.size() * 2;
            pathData.polePositions.put(n2).put(n2 + 1);
            if (pathData.hasExtrusionPoints) {
                pathData.positionPoints.put(n2);
            } else {
                pathData.positionPoints.put(pathData.tessellatedPositions.size());
            }
        }
        pathData.tessellatedPositions.add(position);
        if (color != null) {
            pathData.tessellatedColors.add(color);
        }
    }

    protected Position getPosition(int n) {
        PathData pathData = this.getCurrentPathData();
        int n2 = pathData.positionPoints.get(n);
        return n2 >= 0 && n2 < pathData.tessellatedPositions.size() ? pathData.tessellatedPositions.get(n2) : null;
    }

    protected Integer getOrdinal(int n) {
        return n;
    }

    protected Color getColor(Position position, Integer n) {
        if (this.positionColors == null) {
            return null;
        }
        Color color = this.positionColors.getColor(position, n);
        return color != null ? color : Color.WHITE;
    }

    protected boolean isSegmentVisible(DrawContext drawContext, Position position, Position position2, Vec4 vec4, Vec4 vec42) {
        Frustum frustum = drawContext.getView().getFrustumInModelCoordinates();
        if (frustum.contains(vec4)) {
            return true;
        }
        if (frustum.contains(vec42)) {
            return true;
        }
        if (vec4.equals(vec42)) {
            return false;
        }
        Position position3 = Position.interpolateRhumb(0.5, position, position2);
        Vec4 vec43 = this.computePoint(drawContext.getTerrain(), position3);
        if (frustum.contains(vec43)) {
            return true;
        }
        double d = Line.distanceToSegment(vec4, vec42, vec43);
        Cylinder cylinder = new Cylinder(vec4, vec42, d == 0.0 ? 1.0 : d);
        return cylinder.intersects(drawContext.getView().getFrustumInModelCoordinates());
    }

    protected void makeSegment(DrawContext drawContext, Position position, Position position2, Vec4 vec4, Vec4 vec42, Color color, Color color2, int n, int n2, PathData pathData) {
        boolean bl = this.getPathType() == DEFAULT_PATH_TYPE && !this.isFollowTerrain();
        double d = bl ? vec4.distanceTo3(vec42) : this.computeSegmentLength(drawContext, position, position2);
        if (d <= 0.0 || bl) {
            if (!vec4.equals(vec42)) {
                this.addTessellatedPosition(position2, color2, n2, pathData);
            }
            return;
        }
        Angle angle = null;
        Angle angle2 = null;
        double d2 = 0.0;
        double d3 = 0.0;
        while (d2 < 1.0) {
            LatLon latLon;
            Angle angle3;
            Color color3;
            Position position3;
            d3 = this.isFollowTerrain() ? (d3 += this.terrainConformance * drawContext.getView().computePixelSizeAtDistance(vec4.distanceTo3(drawContext.getView().getEyePoint()))) : (d3 += d / (double)this.numSubsegments);
            d2 = d3 / d;
            if (d2 >= 1.0) {
                position3 = position2;
                color3 = color2;
            } else if (this.pathType == DEFAULT_PATH_TYPE) {
                if (angle == null) {
                    angle = LatLon.linearAzimuth(position, position2);
                    angle2 = LatLon.linearDistance(position, position2);
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.linearEndPosition(position, angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
                color3 = color != null && color2 != null ? WWUtil.interpolateColor(d2, color, color2) : null;
            } else if (this.pathType == "gov.nasa.worldwind.avkey.RhumbLine" || this.pathType == "gov.nasa.worldwind.avkey.Loxodrome") {
                if (angle == null) {
                    angle = LatLon.rhumbAzimuth(position, position2);
                    angle2 = LatLon.rhumbDistance(position, position2);
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.rhumbEndPosition((LatLon)position, angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
                color3 = color != null && color2 != null ? WWUtil.interpolateColor(d2, color, color2) : null;
            } else {
                if (angle == null) {
                    angle = LatLon.greatCircleAzimuth(position, position2);
                    angle2 = LatLon.greatCircleDistance(position, position2);
                }
                angle3 = Angle.fromRadians(d2 * angle2.radians);
                latLon = LatLon.greatCircleEndPosition((LatLon)position, angle, angle3);
                position3 = new Position(latLon, (1.0 - d2) * position.getElevation() + d2 * position2.getElevation());
                color3 = color != null && color2 != null ? WWUtil.interpolateColor(d2, color, color2) : null;
            }
            this.addTessellatedPosition(position3, color3, d2 >= 1.0 ? Integer.valueOf(n2) : null, pathData);
            vec4 = vec42;
        }
    }

    protected double computeSegmentLength(DrawContext drawContext, Position position, Position position2) {
        LatLon latLon = new LatLon(position.getLatitude(), position.getLongitude());
        LatLon latLon2 = new LatLon(position2.getLatitude(), position2.getLongitude());
        String string = this.getPathType();
        Angle angle = string == DEFAULT_PATH_TYPE ? LatLon.linearDistance(latLon, latLon2) : (string == "gov.nasa.worldwind.avkey.RhumbLine" || string == "gov.nasa.worldwind.avkey.Loxodrome" ? LatLon.rhumbDistance(latLon, latLon2) : LatLon.greatCircleDistance(latLon, latLon2));
        if (this.getAltitudeMode() == 1) {
            return angle.radians * drawContext.getGlobe().getRadius();
        }
        double d = 0.5 * (position.getElevation() + position2.getElevation());
        return angle.radians * (drawContext.getGlobe().getRadius() + d * drawContext.getVerticalExaggeration());
    }

    protected Vec4 computeReferenceCenter(DrawContext drawContext) {
        if (this.positions == null) {
            return null;
        }
        Position position = this.getReferencePosition();
        if (position == null) {
            return null;
        }
        return drawContext.getGlobe().computePointFromPosition(position.getLatitude(), position.getLongitude(), drawContext.getVerticalExaggeration() * position.getAltitude());
    }

    protected double computeEyeDistance(DrawContext drawContext, PathData pathData) {
        double d = Double.MAX_VALUE;
        Vec4 vec4 = drawContext.getView().getEyePoint();
        Vec4 vec42 = pathData.getReferencePoint();
        pathData.renderedPath.rewind();
        while (pathData.renderedPath.hasRemaining()) {
            double d2;
            double d3;
            double d4 = vec4.x - ((double)pathData.renderedPath.get() + vec42.x);
            double d5 = d4 * d4 + (d3 = vec4.y - ((double)pathData.renderedPath.get() + vec42.y)) * d3 + (d2 = vec4.z - ((double)pathData.renderedPath.get() + vec42.z)) * d2;
            if (d5 < d) {
                d = d5;
            }
            if (pathData.vertexStride <= 3) continue;
            pathData.renderedPath.position(pathData.renderedPath.position() + pathData.vertexStride - 3);
        }
        return Math.sqrt(d);
    }

    protected Extent computeExtent(PathData pathData) {
        if (pathData.renderedPath == null) {
            return null;
        }
        pathData.renderedPath.rewind();
        Box box = Box.computeBoundingBox(new BufferWrapper.FloatBufferWrapper(pathData.renderedPath), pathData.vertexStride);
        box = box.translate(pathData.getReferencePoint());
        return box;
    }

    @Override
    public Extent getExtent(Globe globe, double d) {
        Iterable<Position> iterable;
        Extent extent = super.getExtent(globe, d);
        if (extent != null) {
            return extent;
        }
        PathData pathData = (PathData)this.shapeDataCache.getEntry(globe);
        if (pathData == null) {
            return null;
        }
        Iterable<Position> iterable2 = iterable = pathData.tessellatedPositions != null ? pathData.tessellatedPositions : this.getPositions();
        if (iterable == null) {
            return null;
        }
        return super.computeExtentFromPositions(globe, d, iterable);
    }

    @Override
    public Position getReferencePosition() {
        return this.numPositions < 1 ? null : this.positions.iterator().next();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void fillVBO(DrawContext drawContext) {
        int n;
        PathData pathData = this.getCurrentPathData();
        int n2 = this.isShowPositions() ? 3 : (pathData.hasExtrusionPoints && this.isDrawVerticals() ? 2 : 1);
        int[] nArray = (int[])drawContext.getGpuResourceCache().get(pathData.getVboCacheKey());
        if (nArray != null && nArray.length != n2) {
            this.clearCachedVbos(drawContext);
            nArray = null;
        }
        GL gL = drawContext.getGL();
        int n3 = pathData.renderedPath.limit() * 4;
        int n4 = n = pathData.hasExtrusionPoints && this.isDrawVerticals() ? pathData.tessellatedPositions.size() * 2 * 4 : 0;
        if (this.isShowPositions()) {
            n += pathData.tessellatedPositions.size();
        }
        if (nArray == null) {
            nArray = new int[n2];
            gL.glGenBuffers(nArray.length, nArray, 0);
            drawContext.getGpuResourceCache().put(pathData.getVboCacheKey(), nArray, "gov.nasa.worldwind.cache.GpuResourceCache.VboBuffers", n3 + n);
        }
        try {
            IntBuffer intBuffer;
            FloatBuffer floatBuffer = pathData.renderedPath;
            gL.glBindBuffer(34962, nArray[0]);
            gL.glBufferData(34962, floatBuffer.limit() * 4, floatBuffer.rewind(), 35044);
            if (pathData.hasExtrusionPoints && this.isDrawVerticals()) {
                intBuffer = pathData.polePositions;
                gL.glBindBuffer(34963, nArray[1]);
                gL.glBufferData(34963, intBuffer.limit() * 4, intBuffer.rewind(), 35044);
            }
            if (this.isShowPositions()) {
                intBuffer = pathData.positionPoints;
                gL.glBindBuffer(34963, nArray[2]);
                gL.glBufferData(34963, intBuffer.limit() * 4, intBuffer.rewind(), 35044);
            }
        }
        finally {
            gL.glBindBuffer(34962, 0);
            gL.glBindBuffer(34963, 0);
        }
    }

    @Override
    public List<Intersection> intersect(Line line, Terrain terrain) throws InterruptedException {
        return null;
    }

    @Override
    public void move(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        this.moveTo(position2.add(position));
    }

    @Override
    public void moveTo(Position position) {
        if (position == null) {
            String string = Logging.getMessage("nullValue.PositionIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        if (this.numPositions == 0) {
            return;
        }
        Position position2 = this.getReferencePosition();
        if (position2 == null) {
            return;
        }
        List<Position> list = Position.computeShiftedPositions(position2, position, this.positions);
        if (list != null) {
            this.setPositions(list);
        }
    }

    protected boolean isSmall(DrawContext drawContext, Vec4 vec4, Vec4 vec42, int n) {
        return vec4.distanceTo3(vec42) <= (double)n * drawContext.getView().computePixelSizeAtDistance(drawContext.getView().getEyePoint().distanceTo3(vec4));
    }

    @Override
    protected void doExportAsKML(XMLStreamWriter xMLStreamWriter) throws IOException, XMLStreamException {
        xMLStreamWriter.writeStartElement("LineString");
        xMLStreamWriter.writeStartElement("extrude");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isExtrude()));
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("tessellate");
        xMLStreamWriter.writeCharacters(KMLExportUtil.kmlBoolean(this.isFollowTerrain()));
        xMLStreamWriter.writeEndElement();
        String string = KMLExportUtil.kmlAltitudeMode(this.getAltitudeMode());
        xMLStreamWriter.writeStartElement("altitudeMode");
        xMLStreamWriter.writeCharacters(string);
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeStartElement("coordinates");
        for (Position position : this.positions) {
            xMLStreamWriter.writeCharacters(String.format(Locale.US, "%f,%f,%f ", position.getLongitude().getDegrees(), position.getLatitude().getDegrees(), position.getElevation()));
        }
        xMLStreamWriter.writeEndElement();
        xMLStreamWriter.writeEndElement();
    }

    protected static class PathPickSupport
    extends PickSupport {
        protected List<PickablePositions> pickablePositions = new ArrayList<PickablePositions>();
        protected Map<Object, PickedObject> pathPickedObjects = new HashMap<Object, PickedObject>();

        protected PathPickSupport() {
        }

        @Override
        public void clearPickList() {
            super.clearPickList();
            this.pickablePositions.clear();
        }

        public List<PickablePositions> getPickablePositions() {
            return this.pickablePositions;
        }

        public void addPickablePositions(int n, int n2, Path path) {
            if (path == null) {
                String string = Logging.getMessage("nullValue.PathIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            this.pickablePositions.add(new PickablePositions(n, n2, path));
            this.adjustExtremeColorCodes(n);
            this.adjustExtremeColorCodes(n2);
        }

        @Override
        public PickedObject getTopObject(DrawContext drawContext, Point point) {
            if (drawContext == null) {
                String string = Logging.getMessage("nullValue.DrawContextIsNull");
                Logging.logger().severe(string);
                throw new IllegalArgumentException(string);
            }
            if (this.getPickableObjects().isEmpty() && this.getPickablePositions().isEmpty()) {
                return null;
            }
            int n = this.getTopColor(drawContext, point);
            if (n == drawContext.getClearColor().getRGB()) {
                return null;
            }
            PickedObject pickedObject = this.getPickableObjects().get(n);
            if (pickedObject != null) {
                return pickedObject;
            }
            for (PickablePositions pickablePositions : this.getPickablePositions()) {
                if (n < pickablePositions.minColorCode || n > pickablePositions.maxColorCode) continue;
                int n2 = n - pickablePositions.minColorCode;
                return pickablePositions.path.resolvePickedPosition(n, n2);
            }
            return null;
        }

        @Override
        protected void doResolvePick(DrawContext drawContext, Rectangle rectangle, Layer layer) {
            if (this.pickableObjects.isEmpty() && this.pickablePositions.isEmpty()) {
                return;
            }
            if (this.pickablePositions.isEmpty()) {
                super.doResolvePick(drawContext, rectangle, layer);
                return;
            }
            int[] nArray = drawContext.getPickColorsInRectangle(rectangle, this.minAndMaxColorCodes);
            if (nArray == null || nArray.length == 0) {
                return;
            }
            block0: for (int n : nArray) {
                if (n == 0) continue;
                PickedObject pickedObject = (PickedObject)this.pickableObjects.get(n);
                if (pickedObject != null) {
                    if (this.pathPickedObjects.containsKey(pickedObject.getObject())) continue;
                    this.pathPickedObjects.put(pickedObject.getObject(), pickedObject);
                    continue;
                }
                for (PickablePositions pickablePositions : this.getPickablePositions()) {
                    if (n < pickablePositions.minColorCode || n > pickablePositions.maxColorCode) continue;
                    Path path = pickablePositions.path;
                    pickedObject = this.pathPickedObjects.get(path);
                    if (pickedObject == null) {
                        pickedObject = path.createPickedObject(n);
                        this.pathPickedObjects.put(path, pickedObject);
                    }
                    int n2 = path.getOrdinal(n - pickablePositions.minColorCode);
                    ArrayList<Integer> arrayList = (ArrayList<Integer>)pickedObject.getValue("gov.nasa.worldwind.avkey.OrdinalList");
                    if (arrayList == null) {
                        arrayList = new ArrayList<Integer>();
                        pickedObject.setValue("gov.nasa.worldwind.avkey.OrdinalList", arrayList);
                    }
                    arrayList.add(n2);
                    continue block0;
                }
            }
            Object object = this.pathPickedObjects.values().iterator();
            while (object.hasNext()) {
                PickedObject pickedObject = (PickedObject)object.next();
                if (layer != null) {
                    pickedObject.setParentLayer(layer);
                }
                drawContext.addObjectInPickRectangle(pickedObject);
            }
            this.pathPickedObjects.clear();
        }
    }

    protected static class PickablePositions {
        public final int minColorCode;
        public final int maxColorCode;
        public final Path path;

        public PickablePositions(int n, int n2, Path path) {
            this.minColorCode = n;
            this.maxColorCode = n2;
            this.path = path;
        }
    }

    protected static class PathData
    extends AbstractShape.AbstractShapeData {
        protected ArrayList<Position> tessellatedPositions;
        protected ArrayList<Color> tessellatedColors;
        protected FloatBuffer renderedPath;
        protected IntBuffer polePositions;
        protected IntBuffer positionPoints;
        protected boolean hasExtrusionPoints;
        protected int colorOffset;
        protected int vertexStride;
        protected int vertexCount;

        public PathData(DrawContext drawContext, Path path) {
            super(drawContext, path.minExpiryTime, path.maxExpiryTime);
        }

        public List<Position> getTessellatedPositions() {
            return this.tessellatedPositions;
        }

        public void setTessellatedPositions(ArrayList<Position> arrayList) {
            this.tessellatedPositions = arrayList;
        }

        public List<Color> getTessellatedColors() {
            return this.tessellatedColors;
        }

        public void setTessellatedColors(ArrayList<Color> arrayList) {
            this.tessellatedColors = arrayList;
        }

        public FloatBuffer getRenderedPath() {
            return this.renderedPath;
        }

        public void setRenderedPath(FloatBuffer floatBuffer) {
            this.renderedPath = floatBuffer;
        }

        public IntBuffer getPositionPoints() {
            return this.positionPoints;
        }

        public void setPositionPoints(IntBuffer intBuffer) {
            this.positionPoints = intBuffer;
        }

        public IntBuffer getPolePositions() {
            return this.polePositions;
        }

        public void setPolePositions(IntBuffer intBuffer) {
            this.polePositions = intBuffer;
        }

        public boolean isHasExtrusionPoints() {
            return this.hasExtrusionPoints;
        }

        public void setHasExtrusionPoints(boolean bl) {
            this.hasExtrusionPoints = bl;
        }

        public int getColorOffset() {
            return this.colorOffset;
        }

        public void setColorOffset(int n) {
            this.colorOffset = n;
        }

        public int getVertexStride() {
            return this.vertexStride;
        }

        public void setVertexStride(int n) {
            this.vertexStride = n;
        }

        public int getVertexCount() {
            return this.vertexCount;
        }

        public void setVertexCount(int n) {
            this.vertexCount = n;
        }
    }

    public static interface PositionColors {
        public Color getColor(Position var1, int var2);
    }
}

