/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.WWUtil;
import javax.media.opengl.GL;
import javax.media.opengl.GLContext;

public class GLRuntimeCapabilities {
    protected static final String GL_EXT_FRAMEBUFFER_OBJECT_STRING = "GL_EXT_framebuffer_object";
    protected static final String GL_EXT_TEXTURE_FILTER_ANISOTROPIC_STRING = "GL_EXT_texture_filter_anisotropic";
    protected double glVersion;
    protected boolean isAnisotropicTextureFilterAvailable;
    protected boolean isAnisotropicTextureFilterEnabled = true;
    protected boolean isFramebufferObjectAvailable;
    protected boolean isFramebufferObjectEnabled = true;
    protected boolean isVertexBufferObjectAvailable;
    protected boolean isVertexBufferObjectEnabled = Configuration.getBooleanValue("gov.nasa.worldwind.avkey.VBOUsage", true);
    protected double maxTextureAnisotropy = -1.0;
    protected int maxTextureSize;
    protected int numTextureUnits;

    public void initialize(GLContext gLContext) {
        Double d;
        Object object;
        if (gLContext == null) {
            String string = Logging.getMessage("nullValue.GLContextIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        GL gL = gLContext.getGL();
        if (this.glVersion < 1.0 && (object = gL.glGetString(7938)) != null && (d = WWUtil.convertStringToDouble((String)(object = ((String)object).substring(0, 3)))) != null) {
            this.glVersion = d;
        }
        this.isAnisotropicTextureFilterAvailable = gL.isExtensionAvailable(GL_EXT_TEXTURE_FILTER_ANISOTROPIC_STRING);
        this.isFramebufferObjectAvailable = gL.isExtensionAvailable(GL_EXT_FRAMEBUFFER_OBJECT_STRING);
        boolean bl = this.isVertexBufferObjectAvailable = this.glVersion >= 1.5;
        if (this.maxTextureAnisotropy < 0.0 && this.isAnisotropicTextureFilterAvailable) {
            object = new double[1];
            gLContext.getGL().glGetDoublev(34047, (double[])object, 0);
            this.maxTextureAnisotropy = (double)object[0];
        }
        if (this.numTextureUnits == 0) {
            object = new int[1];
            gL.glGetIntegerv(34018, (int[])object, 0);
            this.numTextureUnits = (int)object[0];
        }
        if (this.maxTextureSize == 0) {
            object = new int[1];
            gL.glGetIntegerv(3379, (int[])object, 0);
            this.maxTextureSize = (int)object[0];
        }
    }

    public double getGLVersion() {
        return this.glVersion;
    }

    public void setGLVersion(double d) {
        this.glVersion = d;
    }

    public boolean isUseAnisotropicTextureFilter() {
        return this.isAnisotropicTextureFilterAvailable && this.isAnisotropicTextureFilterEnabled;
    }

    public boolean isUseFramebufferObject() {
        return this.isFramebufferObjectAvailable && this.isFramebufferObjectEnabled;
    }

    public boolean isUseVertexBufferObject() {
        return this.isVertexBufferObjectAvailable && this.isVertexBufferObjectEnabled;
    }

    public boolean isAnisotropicTextureFilterAvailable() {
        return this.isAnisotropicTextureFilterAvailable;
    }

    public void setAnisotropicTextureFilterAvailable(boolean bl) {
        this.isAnisotropicTextureFilterAvailable = bl;
    }

    public boolean isAnisotropicTextureFilterEnabled() {
        return this.isAnisotropicTextureFilterEnabled;
    }

    public void setAnisotropicTextureFilterEnabled(boolean bl) {
        this.isAnisotropicTextureFilterEnabled = bl;
    }

    public boolean isFramebufferObjectAvailable() {
        return this.isFramebufferObjectAvailable;
    }

    public void setFramebufferObjectAvailable(boolean bl) {
        this.isFramebufferObjectAvailable = bl;
    }

    public boolean isFramebufferObjectEnabled() {
        return this.isFramebufferObjectEnabled;
    }

    public void setFramebufferObjectEnabled(boolean bl) {
        this.isFramebufferObjectEnabled = bl;
    }

    public boolean isVertexBufferObjectAvailable() {
        return this.isVertexBufferObjectAvailable;
    }

    public void setVertexBufferObjectAvailable(boolean bl) {
        this.isVertexBufferObjectAvailable = bl;
    }

    public boolean isVertexBufferObjectEnabled() {
        return this.isVertexBufferObjectEnabled;
    }

    public void setVertexBufferObjectEnabled(boolean bl) {
        this.isVertexBufferObjectEnabled = bl;
    }

    public double getMaxTextureAnisotropy() {
        return this.maxTextureAnisotropy;
    }

    public void setMaxTextureAnisotropy(double d) {
        this.maxTextureAnisotropy = d;
    }

    public int getMaxTextureSize() {
        return this.maxTextureSize;
    }

    public void setMaxTextureSize(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.MaxTextureSizeLessThanOne");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.maxTextureSize = n;
    }

    public int getNumTextureUnits() {
        return this.numTextureUnits;
    }

    public void setNumTextureUnits(int n) {
        if (n < 1) {
            String string = Logging.getMessage("generic.NumTextureUnitsLessThanOne");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.numTextureUnits = n;
    }
}

