/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.render;

import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.LightingModel;
import gov.nasa.worldwind.render.Material;
import gov.nasa.worldwind.util.Logging;
import gov.nasa.worldwind.util.OGLStackHandler;
import javax.media.opengl.GL;

public class BasicLightingModel
implements LightingModel {
    protected OGLStackHandler lightingStackHandler = new OGLStackHandler();
    protected Vec4 lightDirection = new Vec4(1.0, 0.5, 1.0);
    protected Material lightMaterial = Material.WHITE;
    protected long frameID;

    @Override
    public void beginLighting(DrawContext drawContext) {
        if (this.lightingStackHandler.isActive()) {
            return;
        }
        this.lightingStackHandler.pushAttrib(drawContext.getGL(), 64);
        this.apply(drawContext);
    }

    @Override
    public void endLighting(DrawContext drawContext) {
        this.lightingStackHandler.pop(drawContext.getGL());
        this.lightingStackHandler.clear();
    }

    public Vec4 getLightDirection() {
        return this.lightDirection;
    }

    public void setLightDirection(Vec4 vec4) {
        if (vec4 == null) {
            String string = Logging.getMessage("nullValue.LightDirectionIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.lightDirection = vec4;
    }

    public Material getLightMaterial() {
        return this.lightMaterial;
    }

    public void setLightMaterial(Material material) {
        if (material == null) {
            String string = Logging.getMessage("nullValue.LightMaterialIsNull");
            Logging.logger().severe(string);
            throw new IllegalStateException(string);
        }
        this.lightMaterial = material;
    }

    protected void apply(DrawContext drawContext) {
        GL gL = drawContext.getGL();
        gL.glEnable(2896);
        this.applyStandardLightModel(gL);
        this.applyStandardShadeModel(gL);
        gL.glEnable(16384);
        BasicLightingModel.applyStandardLightMaterial(gL, 16384, this.lightMaterial);
        this.applyStandardLightDirection(gL, 16384, this.lightDirection);
    }

    protected void applyStandardLightModel(GL gL) {
        float[] fArray = new float[]{1.0f, 1.0f, 1.0f, 0.0f};
        gL.glLightModelfv(2899, fArray, 0);
        gL.glLightModeli(2897, 1);
        gL.glLightModeli(2898, 1);
    }

    protected void applyStandardShadeModel(GL gL) {
        gL.glShadeModel(7425);
    }

    protected static void applyStandardLightMaterial(GL gL, int n, Material material) {
        float[] fArray = new float[4];
        float[] fArray2 = new float[4];
        float[] fArray3 = new float[4];
        material.getDiffuse().getRGBColorComponents(fArray2);
        material.getSpecular().getRGBColorComponents(fArray3);
        fArray3[3] = 0.0f;
        fArray2[3] = 0.0f;
        fArray[3] = 0.0f;
        gL.glLightfv(n, 4608, fArray, 0);
        gL.glLightfv(n, 4609, fArray2, 0);
        gL.glLightfv(n, 4610, fArray3, 0);
    }

    protected void applyStandardLightDirection(GL gL, int n, Vec4 vec4) {
        Vec4 vec42 = vec4.normalize3();
        float[] fArray = new float[]{(float)vec42.x, (float)vec42.y, (float)vec42.z, 0.0f};
        gL.glMatrixMode(5888);
        gL.glPushMatrix();
        gL.glLoadIdentity();
        gL.glLightfv(n, 4611, fArray, 0);
        gL.glPopMatrix();
    }
}

