/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.wfs;

import gov.nasa.worldwind.ogc.ows.OWSLanguageString;
import gov.nasa.worldwind.ogc.ows.OWSParserContext;
import gov.nasa.worldwind.ogc.wfs.WFSElement;
import gov.nasa.worldwind.ogc.wfs.WFSExtendedDescription;
import gov.nasa.worldwind.ogc.wfs.WFSFeatureType;
import gov.nasa.worldwind.ogc.wfs.WFSFeatureTypeListParser;
import gov.nasa.worldwind.ogc.wfs.WFSMetadataURL;
import gov.nasa.worldwind.ogc.wfs.WFSOutputFormats;
import gov.nasa.worldwind.ogc.wfs.WFSValueListParser;
import gov.nasa.worldwind.ogc.wfs.WFSValueParser;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;

public class WFSParserContext
extends OWSParserContext {
    protected static final String[] StringFields = new String[]{"Name", "DefaultCRS", "OtherCRS", "NoCRS", "Format", "about", "name", "type"};

    public WFSParserContext(XMLEventReader xMLEventReader, String string) {
        super(xMLEventReader, string);
    }

    @Override
    protected void initializeParsers() {
        super.initializeParsers();
        this.initializeWFSVersion2dot0Parsers();
    }

    protected void initializeWFSVersion2dot0Parsers() {
        this.initializeWFSParsers("http://www.opengis.net/wfs/2.0");
    }

    protected void initializeWFSParsers(String string) {
        this.registerParser(new QName(string, "FeatureTypeList"), new WFSFeatureTypeListParser(string));
        this.registerParser(new QName(string, "FeatureType"), new WFSFeatureType(string));
        this.registerParser(new QName(string, "Title"), new OWSLanguageString(string));
        this.registerParser(new QName(string, "Abstract"), new OWSLanguageString(string));
        this.registerParser(new QName(string, "OutputFormats"), new WFSOutputFormats(string));
        this.registerParser(new QName(string, "MetadataURL"), new WFSMetadataURL(string));
        this.registerParser(new QName(string, "ExtendedDescription"), new WFSExtendedDescription(string));
        this.registerParser(new QName(string, "Element"), new WFSElement(string));
        this.registerParser(new QName(string, "ValueList"), new WFSValueListParser(string));
        this.registerParser(new QName(string, "Value"), new WFSValueParser(string));
        this.addStringParsers(string, StringFields);
    }
}

