/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.ows;

import gov.nasa.worldwind.ogc.ows.OWSAbstractMetaData;
import gov.nasa.worldwind.ogc.ows.OWSAddress;
import gov.nasa.worldwind.ogc.ows.OWSAllowedValues;
import gov.nasa.worldwind.ogc.ows.OWSAnyValue;
import gov.nasa.worldwind.ogc.ows.OWSBoundingBox;
import gov.nasa.worldwind.ogc.ows.OWSCodeType;
import gov.nasa.worldwind.ogc.ows.OWSContactInformation;
import gov.nasa.worldwind.ogc.ows.OWSDCPType;
import gov.nasa.worldwind.ogc.ows.OWSDomain;
import gov.nasa.worldwind.ogc.ows.OWSDomainMetadata;
import gov.nasa.worldwind.ogc.ows.OWSException;
import gov.nasa.worldwind.ogc.ows.OWSKeywords;
import gov.nasa.worldwind.ogc.ows.OWSLanguageString;
import gov.nasa.worldwind.ogc.ows.OWSLanguages;
import gov.nasa.worldwind.ogc.ows.OWSMetadata;
import gov.nasa.worldwind.ogc.ows.OWSNoValues;
import gov.nasa.worldwind.ogc.ows.OWSOnlineResource;
import gov.nasa.worldwind.ogc.ows.OWSOperation;
import gov.nasa.worldwind.ogc.ows.OWSOperationsMetadata;
import gov.nasa.worldwind.ogc.ows.OWSPositionParser;
import gov.nasa.worldwind.ogc.ows.OWSProtocol;
import gov.nasa.worldwind.ogc.ows.OWSRange;
import gov.nasa.worldwind.ogc.ows.OWSRequestMethod;
import gov.nasa.worldwind.ogc.ows.OWSResponsibleParty;
import gov.nasa.worldwind.ogc.ows.OWSResponsiblePartySubset;
import gov.nasa.worldwind.ogc.ows.OWSServiceIdentification;
import gov.nasa.worldwind.ogc.ows.OWSServiceProvider;
import gov.nasa.worldwind.ogc.ows.OWSTelephone;
import gov.nasa.worldwind.ogc.ows.OWSValuesReference;
import gov.nasa.worldwind.ogc.ows.OWSWGS84BoundingBox;
import gov.nasa.worldwind.util.xml.BasicXMLEventParserContext;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;

public class OWSParserContext
extends BasicXMLEventParserContext {
    protected static final String[] ISO_19115_StringFields = new String[]{"codeSpace", "IndividualName", "OrganisationName", "PositionName", "HoursOfService", "ContactInstructions", "Voice", "Facsimile", "DeliveryPoint", "City", "AdministrativeArea", "PostalCode", "Country", "ElectronicMailAddress"};
    protected static final String[] OWSCommonStringFields = new String[]{"about", "crs"};
    protected static final String[] OWSCommonIntegerFields = new String[]{"dimensions"};
    protected static final String[] OWSDataIdentificationStringFields = new String[]{"OutputFormat", "AvailableCRS", "SupportedCRS", "AccessConstraints", "Fees", "Language"};
    protected static final String[] OWSDomainTypeStringFields = new String[]{"name", "reference", "Value", "DefaultValue", "MinimumValue", "MaximumValue", "Spacing", "rangeClosure"};
    protected static final String[] OWSExceptionReportStringFields = new String[]{"version", "exceptionCode", "locator", "ExceptionText"};
    protected static final String[] OWSGetCapabilitiesStringFields = new String[]{"UpdateSequence"};
    protected static final String[] OWSOperationsMetadataStringFields = new String[0];
    protected static final String[] OWSServiceIdentificationStringFields = new String[]{"ServiceTypeVersion", "Profile"};
    protected static final String[] OWSServiceProviderStringFields = new String[]{"ProviderName"};
    protected static final String[] XLinkStringFields = new String[]{"type", "href", "role", "arcrole", "title", "show", "actuate"};
    protected static final String[] XMLStringFields = new String[]{"lang"};

    public OWSParserContext(XMLEventReader xMLEventReader, String string) {
        super(xMLEventReader, string);
    }

    @Override
    protected void initializeParsers() {
        super.initializeParsers();
        this.initializeOWSVersion1dot1Parsers();
    }

    protected void initializeOWSVersion1dot1Parsers() {
        this.initializeOWSParsers("http://www.opengis.net/ows/1.1");
        this.initializeXLinkParsers();
        this.initailizeXMLStandardParsers();
    }

    protected void initializeOWSParsers(String string) {
        this.initializeISO19115Parsers(string);
        this.initializeOWSCommonParsers(string);
        this.initializeOWSDataIdentificationParsers(string);
        this.initializeOWSDomainTypeParsers(string);
        this.initializeOWSExceptionReportParsers(string);
        this.initializeOWSGetCapabilitiesParsers(string);
        this.initializeOWSOperationsMetadataParsers(string);
        this.initializeOWSServiceIdentificationParsers(string);
        this.initializeOWSServiceProviderParsers(string);
    }

    protected void initializeISO19115Parsers(String string) {
        this.registerParser(new QName(string, "Title"), new OWSLanguageString(string));
        this.registerParser(new QName(string, "Abstract"), new OWSLanguageString(string));
        this.registerParser(new QName(string, "Keywords"), new OWSKeywords(string));
        this.registerParser(new QName(string, "Keyword"), new OWSLanguageString(string));
        this.registerParser(new QName(string, "Type"), new OWSCodeType(string));
        this.registerParser(new QName(string, "PointOfContact"), new OWSResponsibleParty(string));
        this.registerParser(new QName(string, "ContactInfo"), new OWSContactInformation(string));
        this.registerParser(new QName(string, "Role"), new OWSCodeType(string));
        this.registerParser(new QName(string, "Phone"), new OWSTelephone(string));
        this.registerParser(new QName(string, "Address"), new OWSAddress(string));
        this.registerParser(new QName(string, "OnlineResource"), new OWSOnlineResource(string));
        this.addStringParsers(string, ISO_19115_StringFields);
    }

    protected void initializeOWSCommonParsers(String string) {
        this.registerParser(new QName(string, "Metadata"), new OWSMetadata(string));
        this.registerParser(new QName(string, "AbstractMetaData"), new OWSAbstractMetaData(string));
        this.registerParser(new QName(string, "BoundingBox"), new OWSBoundingBox(string));
        this.registerParser(new QName(string, "WGS84BoundingBox"), new OWSWGS84BoundingBox(string));
        this.registerParser(new QName(string, "LowerCorner"), new OWSPositionParser(string));
        this.registerParser(new QName(string, "UpperCorner"), new OWSPositionParser(string));
        this.addStringParsers(string, OWSCommonStringFields);
        this.addIntegerParsers(string, OWSCommonIntegerFields);
    }

    protected void initializeOWSDataIdentificationParsers(String string) {
        this.registerParser(new QName(string, "Identifier"), new OWSCodeType(string));
        this.addStringParsers(string, OWSDataIdentificationStringFields);
    }

    protected void initializeOWSDomainTypeParsers(String string) {
        this.registerParser(new QName(string, "AllowedValues"), new OWSAllowedValues(string));
        this.registerParser(new QName(string, "AnyValue"), new OWSAnyValue(string));
        this.registerParser(new QName(string, "NoValues"), new OWSNoValues(string));
        this.registerParser(new QName(string, "ValuesReference"), new OWSValuesReference(string));
        this.registerParser(new QName(string, "Meaning"), new OWSDomainMetadata(string));
        this.registerParser(new QName(string, "DataType"), new OWSDomainMetadata(string));
        this.registerParser(new QName(string, "UOM"), new OWSDomainMetadata(string));
        this.registerParser(new QName(string, "ReferenceSystem"), new OWSDomainMetadata(string));
        this.registerParser(new QName(string, "Range"), new OWSRange(string));
        this.addStringParsers(string, OWSDomainTypeStringFields);
    }

    protected void initializeOWSExceptionReportParsers(String string) {
        this.registerParser(new QName(string, "Exception"), new OWSException(string));
        this.addStringParsers(string, OWSExceptionReportStringFields);
    }

    protected void initializeOWSGetCapabilitiesParsers(String string) {
        this.registerParser(new QName(string, "Languages"), new OWSLanguages(string));
        this.addStringParsers(string, OWSGetCapabilitiesStringFields);
    }

    protected void initializeOWSOperationsMetadataParsers(String string) {
        this.registerParser(new QName(string, "OperationsMetadata"), new OWSOperationsMetadata(string));
        this.registerParser(new QName(string, "Operation"), new OWSOperation(string));
        this.registerParser(new QName(string, "Parameter"), new OWSDomain(string));
        this.registerParser(new QName(string, "Constraint"), new OWSDomain(string));
        this.registerParser(new QName(string, "DCP"), new OWSDCPType(string));
        this.registerParser(new QName(string, "HTTP"), new OWSProtocol(string));
        this.registerParser(new QName(string, "Get"), new OWSRequestMethod(string));
        this.registerParser(new QName(string, "Post"), new OWSRequestMethod(string));
        this.addStringParsers(string, OWSOperationsMetadataStringFields);
    }

    protected void initializeOWSServiceIdentificationParsers(String string) {
        this.registerParser(new QName(string, "ServiceIdentification"), new OWSServiceIdentification(string));
        this.registerParser(new QName(string, "ServiceType"), new OWSCodeType(string));
        this.addStringParsers(string, OWSServiceIdentificationStringFields);
    }

    protected void initializeOWSServiceProviderParsers(String string) {
        this.registerParser(new QName(string, "ServiceProvider"), new OWSServiceProvider(string));
        this.registerParser(new QName(string, "ProviderSite"), new OWSOnlineResource(string));
        this.registerParser(new QName(string, "ServiceContact"), new OWSResponsiblePartySubset(string));
        this.addStringParsers(string, OWSServiceProviderStringFields);
    }

    protected void initializeXLinkParsers() {
        this.addStringParsers("http://www.w3.org/1999/xlink", XLinkStringFields);
    }

    protected void initailizeXMLStandardParsers() {
        this.addStringParsers("http://www.w3.org/XML/1998/namespace", XMLStringFields);
    }
}

