/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc.collada;

import gov.nasa.worldwind.ogc.collada.ColladaAbstractObject;
import gov.nasa.worldwind.util.WWUtil;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class ColladaFloatArray
extends ColladaAbstractObject {
    protected float[] floats;

    public ColladaFloatArray(String string) {
        super(string);
    }

    public float[] getFloats() {
        return this.floats != null ? this.floats : new float[]{};
    }

    @Override
    public Object parse(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        super.parse(xMLEventParserContext, xMLEvent, objectArray);
        if (this.hasField("CharactersContent")) {
            String string = (String)this.getField("CharactersContent");
            if (!WWUtil.isEmpty(string)) {
                this.floats = this.parseFloats(string);
            }
            this.removeField("CharactersContent");
        }
        return this;
    }

    protected float[] parseFloats(String string) {
        String[] stringArray = string.split("\\s");
        float[] fArray = new float[stringArray.length];
        int n = 0;
        for (String string2 : stringArray) {
            if (WWUtil.isEmpty(string2)) continue;
            fArray[n++] = Float.parseFloat(string2);
        }
        return fArray;
    }
}

