/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.ogc;

import gov.nasa.worldwind.ogc.OGCOnlineResource;
import gov.nasa.worldwind.util.xml.AbstractXMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParser;
import gov.nasa.worldwind.util.xml.XMLEventParserContext;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class OGCDCType
extends AbstractXMLEventParser {
    protected QName GET;
    protected QName POST;
    protected QName HTTP;
    protected QName ONLINE_RESOURCE;
    protected List<DCPInfo> protocols = new ArrayList<DCPInfo>(1);

    public OGCDCType(String string) {
        super(string);
        this.initialize();
    }

    @Override
    public XMLEventParser allocate(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent) {
        OGCOnlineResource oGCOnlineResource = null;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.ONLINE_RESOURCE)) {
            oGCOnlineResource = new OGCOnlineResource(this.getNamespaceURI());
        }
        return xMLEventParserContext.allocate(xMLEvent, oGCOnlineResource);
    }

    private void initialize() {
        this.GET = new QName(this.getNamespaceURI(), "Get");
        this.POST = new QName(this.getNamespaceURI(), "Post");
        this.HTTP = new QName(this.getNamespaceURI(), "HTTP");
        this.ONLINE_RESOURCE = new QName(this.getNamespaceURI(), "OnlineResource");
    }

    @Override
    protected void doParseEventContent(XMLEventParserContext xMLEventParserContext, XMLEvent xMLEvent, Object ... objectArray) throws XMLStreamException {
        Object object;
        XMLEventParser xMLEventParser;
        if (xMLEventParserContext.isStartElement(xMLEvent, this.HTTP)) {
            this.addProtocol(xMLEvent.asStartElement().getName().getLocalPart());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.GET) || xMLEventParserContext.isStartElement(xMLEvent, this.POST)) {
            this.addRequestMethod(xMLEvent.asStartElement().getName().getLocalPart());
        } else if (xMLEventParserContext.isStartElement(xMLEvent, this.ONLINE_RESOURCE) && (xMLEventParser = this.allocate(xMLEventParserContext, xMLEvent)) != null && (object = xMLEventParser.parse(xMLEventParserContext, xMLEvent, objectArray)) != null && object instanceof OGCOnlineResource) {
            this.addOnlineResource((OGCOnlineResource)object);
        }
    }

    public List<DCPInfo> getDCPInfos() {
        return this.protocols;
    }

    protected void addProtocol(String string) {
        this.protocols.add(new DCPInfo(string));
    }

    protected void addRequestMethod(String string) {
        DCPInfo dCPInfo = this.protocols.get(this.protocols.size() - 1);
        if (dCPInfo.method != null) {
            dCPInfo = new DCPInfo(dCPInfo.protocol);
            this.protocols.add(dCPInfo);
        }
        dCPInfo.method = string;
    }

    protected void addOnlineResource(OGCOnlineResource oGCOnlineResource) {
        DCPInfo dCPInfo = this.protocols.get(this.protocols.size() - 1);
        dCPInfo.onlineResource = oGCOnlineResource;
    }

    public OGCOnlineResource getOnlineResouce(String string, String string2) {
        for (DCPInfo dCPInfo : this.getDCPInfos()) {
            if (!dCPInfo.protocol.equalsIgnoreCase(string) || !dCPInfo.method.equalsIgnoreCase(string2)) continue;
            return dCPInfo.onlineResource;
        }
        return null;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (DCPInfo dCPInfo : this.getDCPInfos()) {
            stringBuilder.append(dCPInfo.protocol).append(", ");
            stringBuilder.append(dCPInfo.method).append(", ");
            stringBuilder.append(dCPInfo.onlineResource.toString());
        }
        return stringBuilder.toString();
    }

    public static class DCPInfo {
        protected String protocol;
        protected String method;
        protected OGCOnlineResource onlineResource;

        public DCPInfo(String string) {
            this.protocol = string;
        }
    }
}

