/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import gov.nasa.worldwind.geom.Position;
import gov.nasa.worldwind.layers.RenderableLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.util.Logging;
import java.awt.Color;
import java.awt.Rectangle;
import javax.media.opengl.GL;

public class SkyColorLayer
extends RenderableLayer {
    private Color color = new Color(73, 131, 204);
    private double fadeBottomAltitude = 50000.0;
    private double fadeTopAltitude = 140000.0;

    public SkyColorLayer() {
    }

    public SkyColorLayer(Color color) {
        this.setSkyColor(color);
    }

    public Color getSkyColor() {
        return this.color;
    }

    public void setSkyColor(Color color) {
        if (color == null) {
            String string = Logging.getMessage("nullValue.ColorIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        this.color = color;
    }

    public double getFadeBottomAltitude() {
        return this.fadeBottomAltitude;
    }

    public void setFadeBottomAltitude(double d) {
        this.fadeBottomAltitude = d;
    }

    public double getFadeTopAltitude() {
        return this.fadeTopAltitude;
    }

    public void setFadeTopAltitude(double d) {
        this.fadeTopAltitude = d;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void doRender(DrawContext drawContext) {
        Position position = drawContext.getView().getEyePosition();
        if (position == null) {
            return;
        }
        double d = position.getElevation();
        if (d > this.fadeTopAltitude) {
            return;
        }
        float f = d < this.fadeBottomAltitude ? 1.0f : (float)((this.fadeTopAltitude - d) / (this.fadeTopAltitude - this.fadeBottomAltitude));
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(30977);
            bl = true;
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glDisable(2929);
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -1.0, 1.0);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            gL.glScaled(rectangle.width, rectangle.height, 1.0);
            Color color = this.color;
            gL.glColor4d((float)color.getRed() / 255.0f * f, (float)color.getGreen() / 255.0f * f, (float)color.getBlue() / 255.0f * f, (float)color.getAlpha() / 255.0f * f);
            gL.glDisable(3553);
            drawContext.drawUnitQuad();
        }
        finally {
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.Earth.SkyColorLayer.Name");
    }
}

