/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.layers;

import com.sun.opengl.util.texture.Texture;
import com.sun.opengl.util.texture.TextureCoords;
import com.sun.opengl.util.texture.TextureIO;
import gov.nasa.worldwind.exception.WWRuntimeException;
import gov.nasa.worldwind.geom.Vec4;
import gov.nasa.worldwind.layers.AbstractLayer;
import gov.nasa.worldwind.render.DrawContext;
import gov.nasa.worldwind.render.OrderedRenderable;
import gov.nasa.worldwind.util.Logging;
import java.awt.Point;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.media.opengl.GL;

public class CrosshairLayer
extends AbstractLayer {
    private String iconFilePath = "images/32x32-crosshair-simple.png";
    private double toViewportScale = 1.0;
    private double iconScale = 1.0;
    private String resizeBehavior = "gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly";
    private int iconWidth;
    private int iconHeight;
    private Vec4 locationCenter = null;
    private OrderedIcon orderedImage = new OrderedIcon();

    public CrosshairLayer() {
        this.setOpacity(0.8);
    }

    public CrosshairLayer(String string) {
        this.setIconFilePath(string);
        this.setOpacity(0.8);
    }

    public String getIconFilePath() {
        return this.iconFilePath;
    }

    public void setIconFilePath(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.IconFilePath");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.iconFilePath = string;
    }

    public double getToViewportScale() {
        return this.toViewportScale;
    }

    public void setToViewportScale(double d) {
        this.toViewportScale = d;
    }

    public double getIconScale() {
        return this.iconScale;
    }

    public void setIconScale(double d) {
        this.iconScale = d;
    }

    public String getResizeBehavior() {
        return this.resizeBehavior;
    }

    public void setResizeBehavior(String string) {
        this.resizeBehavior = string;
    }

    public Vec4 getLocationCenter() {
        return this.locationCenter;
    }

    public void setLocationCenter(Vec4 vec4) {
        this.locationCenter = vec4;
    }

    @Override
    protected void doRender(DrawContext drawContext) {
        drawContext.addOrderedRenderable(this.orderedImage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void draw(DrawContext drawContext) {
        if (this.getIconFilePath() == null) {
            return;
        }
        GL gL = drawContext.getGL();
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        try {
            gL.glPushAttrib(30977);
            bl = true;
            Texture texture = drawContext.getTextureCache().getTexture(this.getIconFilePath());
            if (texture == null) {
                this.initializeTexture(drawContext);
                texture = drawContext.getTextureCache().getTexture(this.getIconFilePath());
                if (texture == null) {
                    return;
                }
            }
            gL.glEnable(3553);
            texture.bind();
            gL.glColor4d(1.0, 1.0, 1.0, this.getOpacity());
            gL.glEnable(3042);
            gL.glBlendFunc(770, 771);
            gL.glDisable(2929);
            double d = this.getScaledIconWidth();
            double d2 = this.getScaledIconHeight();
            Rectangle rectangle = drawContext.getView().getViewport();
            gL.glMatrixMode(5889);
            gL.glPushMatrix();
            bl3 = true;
            gL.glLoadIdentity();
            double d3 = d > d2 ? d : d2;
            gL.glOrtho(0.0, rectangle.width, 0.0, rectangle.height, -0.6 * d3, 0.6 * d3);
            gL.glMatrixMode(5888);
            gL.glPushMatrix();
            bl2 = true;
            gL.glLoadIdentity();
            double d4 = this.computeScale(rectangle);
            Vec4 vec4 = this.computeLocation(rectangle, d4);
            gL.glTranslated((int)vec4.x, (int)vec4.y, (int)vec4.z);
            gL.glScaled(d4, d4, 1.0);
            TextureCoords textureCoords = texture.getImageTexCoords();
            gL.glScaled(d, d2, 1.0);
            drawContext.drawUnitQuad(textureCoords);
        }
        finally {
            gL.glBindTexture(3553, 0);
            if (bl3) {
                gL.glMatrixMode(5889);
                gL.glPopMatrix();
            }
            if (bl2) {
                gL.glMatrixMode(5888);
                gL.glPopMatrix();
            }
            if (bl) {
                gL.glPopAttrib();
            }
        }
    }

    private double computeScale(Rectangle rectangle) {
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeShrinkOnly")) {
            return Math.min(1.0, this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth());
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeStretch")) {
            return this.toViewportScale * (double)rectangle.width / this.getScaledIconWidth();
        }
        if (this.resizeBehavior.equals("gov.nasa.worldwind.CompassLayer.ResizeKeepFixedSize")) {
            return 1.0;
        }
        return 1.0;
    }

    private double getScaledIconWidth() {
        return (double)this.iconWidth * this.iconScale;
    }

    private double getScaledIconHeight() {
        return (double)this.iconHeight * this.iconScale;
    }

    private Vec4 computeLocation(Rectangle rectangle, double d) {
        double d2;
        double d3;
        double d4 = this.getScaledIconWidth();
        double d5 = this.getScaledIconHeight();
        double d6 = d * d4;
        double d7 = d * d5;
        if (this.locationCenter != null) {
            d3 = this.locationCenter.x - d6 / 2.0;
            d2 = this.locationCenter.y - d7 / 2.0;
        } else {
            d3 = rectangle.getWidth() / 2.0 - d6 / 2.0;
            d2 = rectangle.getHeight() / 2.0 - d7 / 2.0;
        }
        return new Vec4(d3, d2, 0.0);
    }

    private void initializeTexture(DrawContext drawContext) {
        Object object;
        Object object2;
        Texture texture = drawContext.getTextureCache().getTexture(this.getIconFilePath());
        if (texture != null) {
            return;
        }
        try {
            object2 = this.getClass().getResourceAsStream("/" + this.getIconFilePath());
            if (object2 == null && ((File)(object = new File(this.getIconFilePath()))).exists()) {
                object2 = new FileInputStream((File)object);
            }
            texture = TextureIO.newTexture((InputStream)object2, false, null);
            texture.bind();
            this.iconWidth = texture.getWidth();
            this.iconHeight = texture.getHeight();
            drawContext.getTextureCache().put(this.getIconFilePath(), texture);
        }
        catch (IOException iOException) {
            String string = Logging.getMessage("layers.IOExceptionDuringInitialization");
            Logging.logger().severe(string);
            throw new WWRuntimeException(string, iOException);
        }
        object2 = drawContext.getGL();
        object2.glTexParameteri(3553, 10241, 9729);
        object2.glTexParameteri(3553, 10240, 9729);
        object2.glTexParameteri(3553, 10242, 33071);
        object2.glTexParameteri(3553, 10243, 33071);
        object = new int[1];
        object2.glGetIntegerv(34047, (int[])object, 0);
        object2.glTexParameteri(3553, 34046, (int)object[0]);
    }

    @Override
    public String toString() {
        return Logging.getMessage("layers.CrosshairLayer.Name");
    }

    private class OrderedIcon
    implements OrderedRenderable {
        private OrderedIcon() {
        }

        @Override
        public double getDistanceFromEye() {
            return 0.0;
        }

        @Override
        public void pick(DrawContext drawContext, Point point) {
        }

        @Override
        public void render(DrawContext drawContext) {
            CrosshairLayer.this.draw(drawContext);
        }
    }
}

