/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.geom.coords;

import gov.nasa.worldwind.geom.Angle;
import gov.nasa.worldwind.geom.coords.UPSCoordConverter;
import gov.nasa.worldwind.globes.Globe;
import gov.nasa.worldwind.util.Logging;

public class UPSCoord {
    private final Angle latitude;
    private final Angle longitude;
    private final String hemisphere;
    private final double easting;
    private final double northing;

    public static UPSCoord fromLatLon(Angle angle, Angle angle2) {
        return UPSCoord.fromLatLon(angle, angle2, null);
    }

    public static UPSCoord fromLatLon(Angle angle, Angle angle2, Globe globe) {
        if (angle == null || angle2 == null) {
            String string = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        UPSCoordConverter uPSCoordConverter = new UPSCoordConverter(globe);
        long l = uPSCoordConverter.convertGeodeticToUPS(angle.radians, angle2.radians);
        if (l != 0L) {
            String string = Logging.getMessage("Coord.UPSConversionError");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return new UPSCoord(angle, angle2, uPSCoordConverter.getHemisphere(), uPSCoordConverter.getEasting(), uPSCoordConverter.getNorthing());
    }

    public static UPSCoord fromUTM(String string, double d, double d2) {
        return UPSCoord.fromUPS(string, d, d2, null);
    }

    public static UPSCoord fromUPS(String string, double d, double d2, Globe globe) {
        UPSCoordConverter uPSCoordConverter = new UPSCoordConverter(globe);
        long l = uPSCoordConverter.convertUPSToGeodetic(string, d, d2);
        if (l != 0L) {
            String string2 = Logging.getMessage("Coord.UTMConversionError");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return new UPSCoord(Angle.fromRadians(uPSCoordConverter.getLatitude()), Angle.fromRadians(uPSCoordConverter.getLongitude()), string, d, d2);
    }

    public UPSCoord(Angle angle, Angle angle2, String string, double d, double d2) {
        if (angle == null || angle2 == null) {
            String string2 = Logging.getMessage("nullValue.LatitudeOrLongitudeIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        this.latitude = angle;
        this.longitude = angle2;
        this.hemisphere = string;
        this.easting = d;
        this.northing = d2;
    }

    public Angle getLatitude() {
        return this.latitude;
    }

    public Angle getLongitude() {
        return this.longitude;
    }

    public String getHemisphere() {
        return this.hemisphere;
    }

    public double getEasting() {
        return this.easting;
    }

    public double getNorthing() {
        return this.northing;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("gov.nasa.worldwind.avkey.North".equals(this.hemisphere) ? "N" : "S");
        stringBuilder.append(" ").append(this.easting).append("E");
        stringBuilder.append(" ").append(this.northing).append("N");
        return stringBuilder.toString();
    }
}

