/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.vpf;

import gov.nasa.worldwind.formats.vpf.VPFBasicDataBufferFactory;
import gov.nasa.worldwind.formats.vpf.VPFDataBuffer;
import gov.nasa.worldwind.formats.vpf.VPFDataBufferFactory;
import gov.nasa.worldwind.util.Logging;
import java.util.HashMap;
import java.util.Map;

public enum VPFDataType {
    NULL("X", 0, new VPFBasicDataBufferFactory.NullDataFactory()),
    DATE_AND_TIME("D", 20, new VPFBasicDataBufferFactory.DateTimeDataFactory()),
    TRIPLET_ID("K", -1, new VPFBasicDataBufferFactory.TripledIdDataFactory()),
    TEXT("T", 1, new VPFBasicDataBufferFactory.TextDataFactory("US-ASCII")),
    TEXT_L1("L", 1, new VPFBasicDataBufferFactory.TextDataFactory("ISO-8859-1")),
    TEXT_L2("N", 1, new VPFBasicDataBufferFactory.TextDataFactory("ISO_6937-2-add")),
    TEXT_L3("M", 1, new VPFBasicDataBufferFactory.TextDataFactory("ISO-10646")),
    SHORT_INT("S", 2, new VPFBasicDataBufferFactory.ShortDataFactory()),
    LONG_INT("I", 4, new VPFBasicDataBufferFactory.IntDataFactory()),
    SHORT_FLOAT("F", 4, new VPFBasicDataBufferFactory.FloatDataFactory()),
    LONG_FLOAT("R", 8, new VPFBasicDataBufferFactory.DoubleDataFactory()),
    SHORT_COORD_2I("G", 4, new VPFBasicDataBufferFactory.ShortVecDataFactory(2)),
    LONG_COORD_2I("H", 8, new VPFBasicDataBufferFactory.IntVecDataFactory(2)),
    SHORT_COORD_3I("V", 6, new VPFBasicDataBufferFactory.ShortVecDataFactory(3)),
    LONG_COORD_3I("W", 12, new VPFBasicDataBufferFactory.IntVecDataFactory(3)),
    SHORT_COORD_2F("C", 8, new VPFBasicDataBufferFactory.FloatVecDataFactory(2)),
    LONG_COORD_2F("B", 16, new VPFBasicDataBufferFactory.DoubleVecDataFactory(2)),
    SHORT_COORD_3F("Z", 12, new VPFBasicDataBufferFactory.FloatVecDataFactory(3)),
    LONG_COORD_3F("Y", 24, new VPFBasicDataBufferFactory.DoubleVecDataFactory(3));

    protected String name;
    protected int length;
    protected VPFDataBufferFactory dataBufferFactory;
    private static Map<String, VPFDataType> nameRegistry;

    private VPFDataType(String string2, int n2, VPFDataBufferFactory vPFDataBufferFactory) {
        this.name = string2;
        this.length = n2;
        this.dataBufferFactory = vPFDataBufferFactory;
        VPFDataType.register(string2, this);
    }

    private static void register(String string, VPFDataType vPFDataType) {
        if (nameRegistry == null) {
            nameRegistry = new HashMap<String, VPFDataType>();
        }
        nameRegistry.put(string, vPFDataType);
    }

    public static VPFDataType fromTypeName(String string) {
        if (string == null) {
            String string2 = Logging.getMessage("nullValue.NameIsNull");
            Logging.logger().severe(string2);
            throw new IllegalArgumentException(string2);
        }
        return nameRegistry != null ? nameRegistry.get(string) : null;
    }

    public String getFieldName() {
        return this.name;
    }

    public int getFieldLength() {
        return this.length;
    }

    public boolean isVariableLength() {
        return this.length == -1;
    }

    public VPFDataBuffer createDataBuffer(int n, int n2) {
        if (n < 0) {
            String string = Logging.getMessage("generic.ArgumentOutOfRange", "numRows < 0");
            Logging.logger().severe(string);
            throw new IllegalArgumentException(string);
        }
        return this.dataBufferFactory.newDataBuffer(n, n2);
    }
}

