/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.formats.geojson;

import gov.nasa.worldwind.avlist.AVList;
import gov.nasa.worldwind.formats.geojson.GeoJSONGeometry;
import gov.nasa.worldwind.formats.geojson.GeoJSONPositionArray;
import java.util.Arrays;

public class GeoJSONMultiPolygon
extends GeoJSONGeometry {
    public GeoJSONMultiPolygon(AVList aVList) {
        super(aVList);
    }

    @Override
    public boolean isMultiPolygon() {
        return true;
    }

    public GeoJSONPositionArray[][] getCoordinates() {
        return (GeoJSONPositionArray[][])this.getValue("coordinates");
    }

    public int getPolygonCount() {
        GeoJSONPositionArray[][] geoJSONPositionArrayArray = this.getCoordinates();
        return geoJSONPositionArrayArray != null ? geoJSONPositionArrayArray.length : 0;
    }

    public int getInteriorRingCount(int n) {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates(n);
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 1 ? geoJSONPositionArrayArray.length - 1 : 0;
    }

    public GeoJSONPositionArray[] getCoordinates(int n) {
        GeoJSONPositionArray[][] geoJSONPositionArrayArray = this.getCoordinates();
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 0 ? geoJSONPositionArrayArray[n] : null;
    }

    public GeoJSONPositionArray getExteriorRing(int n) {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates(n);
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 0 ? geoJSONPositionArrayArray[0] : null;
    }

    public GeoJSONPositionArray getInteriorRing(int n, int n2) {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates(n);
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 1 ? geoJSONPositionArrayArray[1 + n2] : null;
    }

    public GeoJSONPositionArray[] getInteriorRings(int n) {
        GeoJSONPositionArray[] geoJSONPositionArrayArray = this.getCoordinates(n);
        return geoJSONPositionArrayArray != null && geoJSONPositionArrayArray.length > 1 ? Arrays.copyOfRange(geoJSONPositionArrayArray, 1, geoJSONPositionArrayArray.length) : null;
    }
}

