/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.worldwind.awt;

import gov.nasa.worldwind.Configuration;
import gov.nasa.worldwind.Disposable;
import gov.nasa.worldwind.WWObjectImpl;
import gov.nasa.worldwind.WorldWindow;
import gov.nasa.worldwind.event.DragSelectEvent;
import gov.nasa.worldwind.event.InputHandler;
import gov.nasa.worldwind.event.SelectEvent;
import gov.nasa.worldwind.event.SelectListener;
import gov.nasa.worldwind.pick.PickedObject;
import gov.nasa.worldwind.pick.PickedObjectList;
import gov.nasa.worldwind.util.Logging;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.beans.PropertyChangeEvent;
import javax.media.opengl.GLJPanel;
import javax.swing.Timer;
import javax.swing.event.EventListenerList;

public class AWTInputHandler
extends WWObjectImpl
implements KeyListener,
MouseListener,
MouseMotionListener,
MouseWheelListener,
FocusListener,
InputHandler,
Disposable {
    protected WorldWindow wwd = null;
    protected EventListenerList eventListeners = new EventListenerList();
    protected Point mousePoint = new Point();
    protected PickedObjectList hoverObjects;
    protected PickedObjectList objectsAtButtonPress;
    protected boolean isHovering = false;
    protected boolean isDragging = false;
    protected boolean forceRedrawOnMousePressed = Configuration.getBooleanValue("gov.nasa.worldwind.avkey.ForceRedrawOnMousePressed", false);
    protected Timer hoverTimer = new Timer(600, new ActionListener(){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (AWTInputHandler.this.pickMatches(AWTInputHandler.this.hoverObjects)) {
                AWTInputHandler.this.isHovering = true;
                AWTInputHandler.this.callSelectListeners(new SelectEvent((Object)AWTInputHandler.this.wwd, "gov.nasa.worldwind.SelectEvent.Hover", AWTInputHandler.this.mousePoint, AWTInputHandler.this.hoverObjects));
                AWTInputHandler.this.hoverTimer.stop();
            }
        }
    });
    protected SelectListener selectListener;

    @Override
    public void dispose() {
        this.hoverTimer.stop();
        this.hoverTimer = null;
        this.setEventSource(null);
        if (this.hoverObjects != null) {
            this.hoverObjects.clear();
        }
        this.hoverObjects = null;
        if (this.objectsAtButtonPress != null) {
            this.objectsAtButtonPress.clear();
        }
        this.objectsAtButtonPress = null;
    }

    @Override
    public void setEventSource(WorldWindow worldWindow) {
        Component component;
        if (worldWindow != null && !(worldWindow instanceof Component)) {
            String string = Logging.getMessage("Awt.AWTInputHandler.EventSourceNotAComponent");
            Logging.logger().finer(string);
            throw new IllegalArgumentException(string);
        }
        if (worldWindow == this.wwd) {
            return;
        }
        this.eventListeners = new EventListenerList();
        if (this.wwd != null) {
            component = (Component)((Object)this.wwd);
            component.removeKeyListener(this);
            component.removeMouseMotionListener(this);
            component.removeMouseListener(this);
            component.removeMouseWheelListener(this);
            component.removeFocusListener(this);
            if (this.selectListener != null) {
                this.wwd.removeSelectListener(this.selectListener);
            }
            if (this.wwd.getSceneController() != null) {
                this.wwd.getSceneController().removePropertyChangeListener("gov.nasa.worldwind.avkey.ViewObject", this);
            }
        }
        this.wwd = worldWindow;
        if (this.wwd == null) {
            return;
        }
        this.wwd.getView().getViewInputHandler().setWorldWindow(this.wwd);
        component = (Component)((Object)this.wwd);
        component.addKeyListener(this);
        component.addMouseMotionListener(this);
        component.addMouseListener(this);
        component.addMouseWheelListener(this);
        component.addFocusListener(this);
        this.selectListener = new SelectListener(){

            @Override
            public void selected(SelectEvent selectEvent) {
                if (selectEvent.getEventAction().equals("gov.nasa.worldwind.SelectEvent.Rollover")) {
                    AWTInputHandler.this.doHover(true);
                }
            }
        };
        this.wwd.addSelectListener(this.selectListener);
        if (this.wwd.getSceneController() != null) {
            this.wwd.getSceneController().addPropertyChangeListener("gov.nasa.worldwind.avkey.ViewObject", this);
        }
    }

    public void removeHoverSelectListener() {
        this.hoverTimer.stop();
        this.hoverTimer = null;
        this.wwd.removeSelectListener(this.selectListener);
    }

    @Override
    public WorldWindow getEventSource() {
        return this.wwd;
    }

    @Override
    public void setHoverDelay(int n) {
        this.hoverTimer.setDelay(n);
    }

    @Override
    public int getHoverDelay() {
        return this.hoverTimer.getDelay();
    }

    public boolean isSmoothViewChanges() {
        return this.wwd.getView().getViewInputHandler().isEnableSmoothing();
    }

    public void setSmoothViewChanges(boolean bl) {
        this.wwd.getView().getViewInputHandler().setEnableSmoothing(bl);
    }

    public boolean isLockViewHeading() {
        return this.wwd.getView().getViewInputHandler().isLockHeading();
    }

    public void setLockViewHeading(boolean bl) {
        this.wwd.getView().getViewInputHandler().setLockHeading(bl);
    }

    public boolean isStopViewOnFocusLost() {
        return this.wwd.getView().getViewInputHandler().isStopOnFocusLost();
    }

    public void setStopViewOnFocusLost(boolean bl) {
        this.wwd.getView().getViewInputHandler().setStopOnFocusLost(bl);
    }

    protected WorldWindow getWorldWindow() {
        return this.wwd;
    }

    protected Point getMousePoint() {
        return this.mousePoint;
    }

    protected void setMousePoint(Point point) {
        this.mousePoint = point;
    }

    protected boolean isHovering() {
        return this.isHovering;
    }

    protected void setHovering(boolean bl) {
        this.isHovering = bl;
    }

    protected PickedObjectList getHoverObjects() {
        return this.hoverObjects;
    }

    protected void setHoverObjects(PickedObjectList pickedObjectList) {
        this.hoverObjects = pickedObjectList;
    }

    protected PickedObjectList getObjectsAtButtonPress() {
        return this.objectsAtButtonPress;
    }

    protected void setObjectsAtButtonPress(PickedObjectList pickedObjectList) {
        this.objectsAtButtonPress = pickedObjectList;
    }

    @Override
    public boolean isForceRedrawOnMousePressed() {
        return this.forceRedrawOnMousePressed;
    }

    @Override
    public void setForceRedrawOnMousePressed(boolean bl) {
        this.forceRedrawOnMousePressed = bl;
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.callKeyTypedListeners(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().keyTyped(keyEvent);
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.callKeyPressedListeners(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().keyPressed(keyEvent);
        }
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
        if (this.wwd == null) {
            return;
        }
        if (keyEvent == null) {
            return;
        }
        this.callKeyReleasedListeners(keyEvent);
        if (!keyEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().keyReleased(keyEvent);
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.wwd.getView() == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        this.callMouseClickedListeners(mouseEvent);
        if (pickedObjectList != null && pickedObjectList.getTopPickedObject() != null && !pickedObjectList.getTopPickedObject().isTerrain()) {
            if (1 == mouseEvent.getButton()) {
                if (mouseEvent.getClickCount() <= 1) {
                    this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.LeftClick", mouseEvent, pickedObjectList));
                } else {
                    this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.LeftDoubleClick", mouseEvent, pickedObjectList));
                }
            } else if (3 == mouseEvent.getButton()) {
                this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.RightClick", mouseEvent, pickedObjectList));
            }
            this.wwd.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.wwd.getView());
        } else if (!mouseEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().mouseClicked(mouseEvent);
        }
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.mousePoint = mouseEvent.getPoint();
        this.cancelHover();
        this.cancelDrag();
        if (this.isForceRedrawOnMousePressed()) {
            this.wwd.redrawNow();
        }
        this.objectsAtButtonPress = this.wwd.getObjectsAtCurrentPosition();
        this.callMousePressedListeners(mouseEvent);
        if (this.objectsAtButtonPress != null && this.objectsAtButtonPress.getTopPickedObject() != null && !this.objectsAtButtonPress.getTopPickedObject().isTerrain()) {
            if (1 == mouseEvent.getButton()) {
                this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.LeftPress", mouseEvent, this.objectsAtButtonPress));
            } else if (3 == mouseEvent.getButton()) {
                this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.RightPress", mouseEvent, this.objectsAtButtonPress));
            }
            this.wwd.getView().firePropertyChange("gov.nasa.worldwind.avkey.ViewObject", null, this.wwd.getView());
        } else if (!mouseEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().mousePressed(mouseEvent);
        }
        if (1 == mouseEvent.getButton() && this.wwd instanceof GLJPanel) {
            ((GLJPanel)((Object)this.wwd)).requestFocusInWindow();
        }
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.mousePoint = mouseEvent.getPoint();
        this.callMouseReleasedListeners(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().mouseReleased(mouseEvent);
        }
        this.doHover(true);
        this.cancelDrag();
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.callMouseEnteredListeners(mouseEvent);
        this.wwd.getView().getViewInputHandler().mouseEntered(mouseEvent);
        this.cancelHover();
        this.cancelDrag();
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.callMouseExitedListeners(mouseEvent);
        this.wwd.getView().getViewInputHandler().mouseExited(mouseEvent);
        if (this.wwd.getSceneController() != null) {
            this.wwd.getSceneController().setPickPoint(null);
            this.wwd.redraw();
        }
        this.cancelHover();
        this.cancelDrag();
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        Point point = this.mousePoint;
        this.mousePoint = mouseEvent.getPoint();
        this.callMouseDraggedListeners(mouseEvent);
        if ((0x400 & mouseEvent.getModifiersEx()) != 0) {
            PickedObjectList pickedObjectList = this.objectsAtButtonPress;
            if (this.isDragging || pickedObjectList != null && pickedObjectList.getTopPickedObject() != null && !pickedObjectList.getTopPickedObject().isTerrain()) {
                this.isDragging = true;
                DragSelectEvent dragSelectEvent = new DragSelectEvent(this.wwd, "gov.nasa.worldwind.SelectEvent.Drag", mouseEvent, pickedObjectList, point);
                this.callSelectListeners(dragSelectEvent);
                if (!dragSelectEvent.isConsumed()) {
                    this.cancelDrag();
                }
            }
        }
        if (!this.isDragging && !mouseEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().mouseDragged(mouseEvent);
        }
        if (this.wwd.getSceneController() != null) {
            this.wwd.getSceneController().setPickPoint(mouseEvent.getPoint());
            this.wwd.redraw();
        }
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseEvent == null) {
            return;
        }
        this.mousePoint = mouseEvent.getPoint();
        this.callMouseMovedListeners(mouseEvent);
        if (!mouseEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().mouseMoved(mouseEvent);
        }
        if (this.wwd.getSceneController() != null) {
            this.wwd.getSceneController().setPickPoint(mouseEvent.getPoint());
            this.wwd.redraw();
        }
    }

    @Override
    public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
        if (this.wwd == null) {
            return;
        }
        if (mouseWheelEvent == null) {
            return;
        }
        this.callMouseWheelMovedListeners(mouseWheelEvent);
        if (!mouseWheelEvent.isConsumed()) {
            this.wwd.getView().getViewInputHandler().mouseWheelMoved(mouseWheelEvent);
        }
    }

    @Override
    public void focusGained(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.wwd.getView().getViewInputHandler().focusGained(focusEvent);
    }

    @Override
    public void focusLost(FocusEvent focusEvent) {
        if (this.wwd == null) {
            return;
        }
        if (focusEvent == null) {
            return;
        }
        this.wwd.getView().getViewInputHandler().focusLost(focusEvent);
    }

    protected boolean isPickListEmpty(PickedObjectList pickedObjectList) {
        return pickedObjectList == null || pickedObjectList.size() < 1;
    }

    protected void doHover(boolean bl) {
        PickedObjectList pickedObjectList = this.wwd.getObjectsAtCurrentPosition();
        if (!this.isPickListEmpty(this.hoverObjects) && !this.isPickListEmpty(pickedObjectList)) {
            Object object;
            Object object2;
            PickedObject pickedObject = this.hoverObjects.getTopPickedObject();
            PickedObject pickedObject2 = pickedObjectList.getTopPickedObject();
            Object object3 = pickedObject == null ? null : (pickedObject.getObject() != null ? pickedObject.getObject() : (object2 = pickedObject.getParentLayer() != null ? pickedObject.getParentLayer() : null));
            Object object4 = pickedObject2 == null ? null : (pickedObject2.getObject() != null ? pickedObject2.getObject() : (object = pickedObject2.getParentLayer() != null ? pickedObject2.getParentLayer() : null));
            if (object2 != null && object != null && object2.equals(object)) {
                return;
            }
        }
        this.cancelHover();
        if (!bl) {
            return;
        }
        if (pickedObjectList != null && pickedObjectList.getTopObject() != null && pickedObjectList.getTopPickedObject().isTerrain()) {
            return;
        }
        this.hoverObjects = pickedObjectList;
        this.hoverTimer.restart();
    }

    protected void cancelHover() {
        if (this.isHovering) {
            this.callSelectListeners(new SelectEvent((Object)this.wwd, "gov.nasa.worldwind.SelectEvent.Hover", this.mousePoint, null));
        }
        this.isHovering = false;
        this.hoverObjects = null;
        this.hoverTimer.stop();
    }

    protected boolean pickMatches(PickedObjectList pickedObjectList) {
        if (this.isPickListEmpty(this.wwd.getObjectsAtCurrentPosition()) || this.isPickListEmpty(pickedObjectList)) {
            return false;
        }
        PickedObject pickedObject = this.wwd.getObjectsAtCurrentPosition().getTopPickedObject();
        if (null != pickedObject && pickedObject.isTerrain()) {
            return false;
        }
        PickedObject pickedObject2 = pickedObjectList.getTopPickedObject();
        if (pickedObject == null || pickedObject2 == null || pickedObject.getObject() == null || pickedObject2.getObject() == null) {
            return false;
        }
        return pickedObject.getObject().equals(pickedObject2.getObject());
    }

    protected void cancelDrag() {
        if (this.isDragging) {
            this.callSelectListeners(new DragSelectEvent(this.wwd, "gov.nasa.worldwind.SelectEvent.DragEnd", null, this.objectsAtButtonPress, this.mousePoint));
        }
        this.isDragging = false;
    }

    @Override
    public void addSelectListener(SelectListener selectListener) {
        this.eventListeners.add(SelectListener.class, selectListener);
    }

    @Override
    public void removeSelectListener(SelectListener selectListener) {
        this.eventListeners.remove(SelectListener.class, selectListener);
    }

    protected void callSelectListeners(SelectEvent selectEvent) {
        for (SelectListener selectListener : (SelectListener[])this.eventListeners.getListeners(SelectListener.class)) {
            selectListener.selected(selectEvent);
        }
    }

    @Override
    public void addKeyListener(KeyListener keyListener) {
        this.eventListeners.add(KeyListener.class, keyListener);
    }

    @Override
    public void removeKeyListener(KeyListener keyListener) {
        this.eventListeners.remove(KeyListener.class, keyListener);
    }

    @Override
    public void addMouseListener(MouseListener mouseListener) {
        this.eventListeners.add(MouseListener.class, mouseListener);
    }

    @Override
    public void removeMouseListener(MouseListener mouseListener) {
        this.eventListeners.remove(MouseListener.class, mouseListener);
    }

    @Override
    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.eventListeners.add(MouseMotionListener.class, mouseMotionListener);
    }

    @Override
    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.eventListeners.remove(MouseMotionListener.class, mouseMotionListener);
    }

    @Override
    public void addMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.eventListeners.add(MouseWheelListener.class, mouseWheelListener);
    }

    @Override
    public void removeMouseWheelListener(MouseWheelListener mouseWheelListener) {
        this.eventListeners.remove(MouseWheelListener.class, mouseWheelListener);
    }

    protected void callKeyPressedListeners(KeyEvent keyEvent) {
        for (KeyListener keyListener : (KeyListener[])this.eventListeners.getListeners(KeyListener.class)) {
            keyListener.keyPressed(keyEvent);
        }
    }

    protected void callKeyReleasedListeners(KeyEvent keyEvent) {
        for (KeyListener keyListener : (KeyListener[])this.eventListeners.getListeners(KeyListener.class)) {
            keyListener.keyReleased(keyEvent);
        }
    }

    protected void callKeyTypedListeners(KeyEvent keyEvent) {
        for (KeyListener keyListener : (KeyListener[])this.eventListeners.getListeners(KeyListener.class)) {
            keyListener.keyTyped(keyEvent);
        }
    }

    protected void callMousePressedListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mousePressed(mouseEvent);
        }
    }

    protected void callMouseReleasedListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mouseReleased(mouseEvent);
        }
    }

    protected void callMouseClickedListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mouseClicked(mouseEvent);
        }
    }

    protected void callMouseDraggedListeners(MouseEvent mouseEvent) {
        for (MouseMotionListener mouseMotionListener : (MouseMotionListener[])this.eventListeners.getListeners(MouseMotionListener.class)) {
            mouseMotionListener.mouseDragged(mouseEvent);
        }
    }

    protected void callMouseMovedListeners(MouseEvent mouseEvent) {
        for (MouseMotionListener mouseMotionListener : (MouseMotionListener[])this.eventListeners.getListeners(MouseMotionListener.class)) {
            mouseMotionListener.mouseMoved(mouseEvent);
        }
    }

    protected void callMouseWheelMovedListeners(MouseWheelEvent mouseWheelEvent) {
        for (MouseWheelListener mouseWheelListener : (MouseWheelListener[])this.eventListeners.getListeners(MouseWheelListener.class)) {
            mouseWheelListener.mouseWheelMoved(mouseWheelEvent);
        }
    }

    protected void callMouseEnteredListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mouseEntered(mouseEvent);
        }
    }

    protected void callMouseExitedListeners(MouseEvent mouseEvent) {
        for (MouseListener mouseListener : (MouseListener[])this.eventListeners.getListeners(MouseListener.class)) {
            mouseListener.mouseExited(mouseEvent);
        }
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.wwd == null) {
            return;
        }
        if (this.wwd.getView() == null) {
            return;
        }
        if (propertyChangeEvent == null) {
            return;
        }
        if (propertyChangeEvent.getPropertyName().equals("gov.nasa.worldwind.avkey.ViewObject") && propertyChangeEvent.getSource() == this.getWorldWindow().getSceneController()) {
            this.wwd.getView().getViewInputHandler().setWorldWindow(this.wwd);
        }
    }
}

